/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.util.matcher;

import java.util.Arrays;
import java.util.List;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OrServerWebExchangeMatcher
implements ServerWebExchangeMatcher {
    private final List<ServerWebExchangeMatcher> matchers;

    public OrServerWebExchangeMatcher(List<ServerWebExchangeMatcher> matchers) {
        Assert.notEmpty(matchers, "matchers cannot be empty");
        this.matchers = matchers;
    }

    public OrServerWebExchangeMatcher(ServerWebExchangeMatcher ... matchers) {
        this(Arrays.asList(matchers));
    }

    @Override
    public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange2) {
        return Flux.fromIterable(this.matchers).flatMap(m3 -> m3.matches(exchange2)).filter(m3 -> m3.isMatch()).next().switchIfEmpty(ServerWebExchangeMatcher.MatchResult.notMatch());
    }

    public String toString() {
        return "OrServerWebExchangeMatcher{matchers=" + this.matchers + '}';
    }
}

