/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.header;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.security.web.server.header.ServerHttpHeadersWriter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class StaticServerHttpHeadersWriter
implements ServerHttpHeadersWriter {
    private final HttpHeaders headersToAdd;

    public StaticServerHttpHeadersWriter(HttpHeaders headersToAdd) {
        this.headersToAdd = headersToAdd;
    }

    @Override
    public Mono<Void> writeHttpHeaders(ServerWebExchange exchange2) {
        HttpHeaders headers2 = exchange2.getResponse().getHeaders();
        boolean containsOneHeaderToAdd = Collections.disjoint(headers2.keySet(), this.headersToAdd.keySet());
        if (containsOneHeaderToAdd) {
            this.headersToAdd.forEach((name, values) -> headers2.put((String)name, (List<String>)values));
        }
        return Mono.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HttpHeaders headers = new HttpHeaders();

        public Builder header(String headerName, String ... values) {
            this.headers.put(headerName, Arrays.asList(values));
            return this;
        }

        public StaticServerHttpHeadersWriter build() {
            return new StaticServerHttpHeadersWriter(this.headers);
        }
    }
}

