/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authorization;

import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class AuthorizationWebFilter
implements WebFilter {
    private ReactiveAuthorizationManager<? super ServerWebExchange> accessDecisionManager;

    public AuthorizationWebFilter(ReactiveAuthorizationManager<? super ServerWebExchange> accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return ReactiveSecurityContextHolder.getContext().filter(c -> c.getAuthentication() != null).map(SecurityContext::getAuthentication).as(authentication -> this.accessDecisionManager.verify((Mono<Authentication>)authentication, exchange2)).switchIfEmpty(chain.filter(exchange2));
    }
}

