/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.springframework.beans.BeanUtils;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.test.context.TestSecurityContextHolder;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.util.MetaAnnotationUtils;

public class WithSecurityContextTestExecutionListener
extends AbstractTestExecutionListener {
    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        SecurityContext securityContext = this.createSecurityContext(testContext.getTestMethod(), testContext);
        if (securityContext == null) {
            securityContext = this.createSecurityContext(testContext.getTestClass(), testContext);
        }
        if (securityContext != null) {
            TestSecurityContextHolder.setContext(securityContext);
        }
    }

    private SecurityContext createSecurityContext(AnnotatedElement annotated, TestContext context) {
        WithSecurityContext withSecurityContext = AnnotationUtils.findAnnotation(annotated, WithSecurityContext.class);
        return this.createSecurityContext(annotated, withSecurityContext, context);
    }

    private SecurityContext createSecurityContext(Class<?> annotated, TestContext context) {
        MetaAnnotationUtils.AnnotationDescriptor<WithSecurityContext> withSecurityContextDescriptor = MetaAnnotationUtils.findAnnotationDescriptor(annotated, WithSecurityContext.class);
        WithSecurityContext withSecurityContext = withSecurityContextDescriptor == null ? null : withSecurityContextDescriptor.getAnnotation();
        return this.createSecurityContext(annotated, withSecurityContext, context);
    }

    private SecurityContext createSecurityContext(AnnotatedElement annotated, WithSecurityContext withSecurityContext, TestContext context) {
        if (withSecurityContext == null) {
            return null;
        }
        WithSecurityContextFactory<? extends Annotation> factory = this.createFactory(withSecurityContext, context);
        Class<?> type = GenericTypeResolver.resolveTypeArgument(factory.getClass(), WithSecurityContextFactory.class);
        Annotation annotation = this.findAnnotation(annotated, type);
        try {
            return factory.createSecurityContext(annotation);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Unable to create SecurityContext using " + annotation, e);
        }
    }

    private Annotation findAnnotation(AnnotatedElement annotated, Class<? extends Annotation> type) {
        Annotation[] allAnnotations;
        Annotation findAnnotation = AnnotationUtils.findAnnotation(annotated, type);
        if (findAnnotation != null) {
            return findAnnotation;
        }
        for (Annotation annotationToTest : allAnnotations = AnnotationUtils.getAnnotations(annotated)) {
            WithSecurityContext withSecurityContext = AnnotationUtils.findAnnotation(annotationToTest.annotationType(), WithSecurityContext.class);
            if (withSecurityContext == null) continue;
            return annotationToTest;
        }
        return null;
    }

    private WithSecurityContextFactory<? extends Annotation> createFactory(WithSecurityContext withSecurityContext, TestContext testContext) {
        Class<? extends WithSecurityContextFactory<? extends Annotation>> clazz = withSecurityContext.factory();
        try {
            return testContext.getApplicationContext().getAutowireCapableBeanFactory().createBean(clazz);
        }
        catch (IllegalStateException e) {
            return BeanUtils.instantiateClass(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        TestSecurityContextHolder.clearContext();
    }

    @Override
    public int getOrder() {
        return 10000;
    }
}

