/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context.support;

import org.reactivestreams.Subscription;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.test.context.TestSecurityContextHolder;
import org.springframework.security.test.context.support.DelegatingTestExecutionListener;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public class ReactorContextTestExecutionListener
extends DelegatingTestExecutionListener {
    private static final String HOOKS_CLASS_NAME = "reactor.core.publisher.Hooks";

    public ReactorContextTestExecutionListener() {
        super(ReactorContextTestExecutionListener.createDelegate());
    }

    private static TestExecutionListener createDelegate() {
        return ClassUtils.isPresent(HOOKS_CLASS_NAME, ReactorContextTestExecutionListener.class.getClassLoader()) ? new DelegateTestExecutionListener() : new AbstractTestExecutionListener(){};
    }

    @Override
    public int getOrder() {
        return 11000;
    }

    private static class DelegateTestExecutionListener
    extends AbstractTestExecutionListener {
        private DelegateTestExecutionListener() {
        }

        @Override
        public void beforeTestMethod(TestContext testContext) throws Exception {
            SecurityContext securityContext = TestSecurityContextHolder.getContext();
            Hooks.onLastOperator(Operators.lift((s2, sub) -> new SecuritySubContext(sub, securityContext)));
        }

        @Override
        public void afterTestMethod(TestContext testContext) throws Exception {
            Hooks.resetOnLastOperator();
        }

        private static class SecuritySubContext<T>
        implements CoreSubscriber<T> {
            private static String CONTEXT_DEFAULTED_ATTR_NAME = SecuritySubContext.class.getName().concat(".CONTEXT_DEFAULTED_ATTR_NAME");
            private final CoreSubscriber<T> delegate;
            private final SecurityContext securityContext;

            SecuritySubContext(CoreSubscriber<T> delegate, SecurityContext securityContext) {
                this.delegate = delegate;
                this.securityContext = securityContext;
            }

            @Override
            public Context currentContext() {
                Context context = this.delegate.currentContext();
                if (context.hasKey(CONTEXT_DEFAULTED_ATTR_NAME)) {
                    return context;
                }
                context = context.put(CONTEXT_DEFAULTED_ATTR_NAME, Boolean.TRUE);
                Authentication authentication = this.securityContext.getAuthentication();
                if (authentication == null) {
                    return context;
                }
                Context toMerge = ReactiveSecurityContextHolder.withSecurityContext(Mono.just(this.securityContext));
                return toMerge.putAll(context);
            }

            @Override
            public void onSubscribe(Subscription s2) {
                this.delegate.onSubscribe(s2);
            }

            @Override
            public void onNext(T t) {
                this.delegate.onNext(t);
            }

            @Override
            public void onError(Throwable t) {
                this.delegate.onError(t);
            }

            @Override
            public void onComplete() {
                this.delegate.onComplete();
            }
        }
    }
}

