/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.debug;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.security.web.debug.DebugFilter;

public class SecurityDebugBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.logger.warn("\n\n********************************************************************\n**********        Security debugging is enabled.       *************\n**********    This may include sensitive information.  *************\n**********      Do not use in a production system!     *************\n********************************************************************\n\n");
        if (registry.containsBeanDefinition("org.springframework.security.filterChainProxy")) {
            BeanDefinition fcpBeanDef = registry.getBeanDefinition("org.springframework.security.filterChainProxy");
            BeanDefinitionBuilder debugFilterBldr = BeanDefinitionBuilder.genericBeanDefinition(DebugFilter.class);
            debugFilterBldr.addConstructorArgValue(fcpBeanDef);
            registry.removeAlias("springSecurityFilterChain");
            registry.registerBeanDefinition("springSecurityFilterChain", debugFilterBldr.getBeanDefinition());
        }
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

