/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.DelegatingServletOutputStream;
import org.springframework.mock.web.HeaderValueHolder;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;

public class MockHttpServletResponse
implements HttpServletResponse {
    private static final String CHARSET_PREFIX = "charset=";
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private boolean outputStreamAccessAllowed = true;
    private boolean writerAccessAllowed = true;
    @Nullable
    private String characterEncoding = "ISO-8859-1";
    private boolean charset = false;
    private final ByteArrayOutputStream content = new ByteArrayOutputStream(1024);
    private final ServletOutputStream outputStream = new ResponseServletOutputStream(this.content);
    @Nullable
    private PrintWriter writer;
    private long contentLength = 0L;
    @Nullable
    private String contentType;
    private int bufferSize = 4096;
    private boolean committed;
    private Locale locale = Locale.getDefault();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, HeaderValueHolder> headers = new LinkedCaseInsensitiveMap<HeaderValueHolder>();
    private int status = 200;
    @Nullable
    private String errorMessage;
    @Nullable
    private String forwardedUrl;
    private final List<String> includedUrls = new ArrayList<String>();

    public void setOutputStreamAccessAllowed(boolean outputStreamAccessAllowed) {
        this.outputStreamAccessAllowed = outputStreamAccessAllowed;
    }

    public boolean isOutputStreamAccessAllowed() {
        return this.outputStreamAccessAllowed;
    }

    public void setWriterAccessAllowed(boolean writerAccessAllowed) {
        this.writerAccessAllowed = writerAccessAllowed;
    }

    public boolean isWriterAccessAllowed() {
        return this.writerAccessAllowed;
    }

    public boolean isCharset() {
        return this.charset;
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
        this.charset = true;
        this.updateContentTypeHeader();
    }

    private void updateContentTypeHeader() {
        if (this.contentType != null) {
            StringBuilder sb = new StringBuilder(this.contentType);
            if (!this.contentType.toLowerCase().contains(CHARSET_PREFIX) && this.charset) {
                sb.append(";").append(CHARSET_PREFIX).append(this.characterEncoding);
            }
            this.doAddHeaderValue("Content-Type", sb.toString(), true);
        }
    }

    @Override
    @Nullable
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public ServletOutputStream getOutputStream() {
        Assert.state(this.outputStreamAccessAllowed, "OutputStream access not allowed");
        return this.outputStream;
    }

    @Override
    public PrintWriter getWriter() throws UnsupportedEncodingException {
        Assert.state(this.writerAccessAllowed, "Writer access not allowed");
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding != null ? new OutputStreamWriter((OutputStream)this.content, this.characterEncoding) : new OutputStreamWriter(this.content);
            this.writer = new ResponsePrintWriter(targetWriter);
        }
        return this.writer;
    }

    public byte[] getContentAsByteArray() {
        return this.content.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        return this.characterEncoding != null ? this.content.toString(this.characterEncoding) : this.content.toString();
    }

    @Override
    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
        this.doAddHeaderValue("Content-Length", contentLength, true);
    }

    public int getContentLength() {
        return (int)this.contentLength;
    }

    @Override
    public void setContentLengthLong(long contentLength) {
        this.contentLength = contentLength;
        this.doAddHeaderValue("Content-Length", contentLength, true);
    }

    public long getContentLengthLong() {
        return this.contentLength;
    }

    @Override
    public void setContentType(@Nullable String contentType2) {
        this.contentType = contentType2;
        if (contentType2 != null) {
            block4: {
                try {
                    MediaType mediaType = MediaType.parseMediaType(contentType2);
                    if (mediaType.getCharset() != null) {
                        this.characterEncoding = mediaType.getCharset().name();
                        this.charset = true;
                    }
                }
                catch (Exception ex) {
                    int charsetIndex = contentType2.toLowerCase().indexOf(CHARSET_PREFIX);
                    if (charsetIndex == -1) break block4;
                    this.characterEncoding = contentType2.substring(charsetIndex + CHARSET_PREFIX.length());
                    this.charset = true;
                }
            }
            this.updateContentTypeHeader();
        }
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void flushBuffer() {
        this.setCommitted(true);
    }

    @Override
    public void resetBuffer() {
        Assert.state(!this.isCommitted(), "Cannot reset buffer - response is already committed");
        this.content.reset();
    }

    private void setCommittedIfBufferSizeExceeded() {
        int bufSize = this.getBufferSize();
        if (bufSize > 0 && this.content.size() > bufSize) {
            this.setCommitted(true);
        }
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentLength = 0L;
        this.contentType = null;
        this.locale = Locale.getDefault();
        this.cookies.clear();
        this.headers.clear();
        this.status = 200;
        this.errorMessage = null;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        this.doAddHeaderValue("Content-Language", locale.toLanguageTag(), true);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void addCookie(Cookie cookie) {
        Assert.notNull((Object)cookie, "Cookie must not be null");
        this.cookies.add(cookie);
        this.doAddHeaderValue("Set-Cookie", this.getCookieHeader(cookie), false);
    }

    private String getCookieHeader(Cookie cookie) {
        int maxAge;
        StringBuilder buf = new StringBuilder();
        buf.append(cookie.getName()).append('=').append(cookie.getValue() == null ? "" : cookie.getValue());
        if (StringUtils.hasText(cookie.getPath())) {
            buf.append("; Path=").append(cookie.getPath());
        }
        if (StringUtils.hasText(cookie.getDomain())) {
            buf.append("; Domain=").append(cookie.getDomain());
        }
        if ((maxAge = cookie.getMaxAge()) >= 0) {
            buf.append("; Max-Age=").append(maxAge);
            buf.append("; Expires=");
            HttpHeaders headers2 = new HttpHeaders();
            headers2.setExpires(maxAge > 0 ? System.currentTimeMillis() + 1000L * (long)maxAge : 0L);
            buf.append(headers2.getFirst("Expires"));
        }
        if (cookie.getSecure()) {
            buf.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            buf.append("; HttpOnly");
        }
        return buf.toString();
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[0]);
    }

    @Nullable
    public Cookie getCookie(String name) {
        Assert.notNull((Object)name, "Cookie name must not be null");
        for (Cookie cookie : this.cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public boolean containsHeader(String name) {
        return HeaderValueHolder.getByName(this.headers, name) != null;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    @Nullable
    public String getHeader(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getStringValue() : null;
    }

    public List<String> getHeaders(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        if (header != null) {
            return header.getStringValues();
        }
        return Collections.emptyList();
    }

    @Nullable
    public Object getHeaderValue(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getValue() : null;
    }

    public List<Object> getHeaderValues(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        if (header != null) {
            return header.getValues();
        }
        return Collections.emptyList();
    }

    @Override
    public String encodeURL(String url) {
        return url;
    }

    @Override
    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    @Override
    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Override
    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    @Override
    public void sendError(int status, String errorMessage) throws IOException {
        Assert.state(!this.isCommitted(), "Cannot set error status - response is already committed");
        this.status = status;
        this.errorMessage = errorMessage;
        this.setCommitted(true);
    }

    @Override
    public void sendError(int status) throws IOException {
        Assert.state(!this.isCommitted(), "Cannot set error status - response is already committed");
        this.status = status;
        this.setCommitted(true);
    }

    @Override
    public void sendRedirect(String url) throws IOException {
        Assert.state(!this.isCommitted(), "Cannot send redirect - response is already committed");
        Assert.notNull((Object)url, "Redirect URL must not be null");
        this.setHeader("Location", url);
        this.setStatus(302);
        this.setCommitted(true);
    }

    @Nullable
    public String getRedirectedUrl() {
        return this.getHeader("Location");
    }

    @Override
    public void setDateHeader(String name, long value) {
        this.setHeaderValue(name, this.formatDate(value));
    }

    @Override
    public void addDateHeader(String name, long value) {
        this.addHeaderValue(name, this.formatDate(value));
    }

    public long getDateHeader(String name) {
        String headerValue = this.getHeader(name);
        if (headerValue == null) {
            return -1L;
        }
        try {
            return this.newDateFormat().parse(this.getHeader(name)).getTime();
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Value for header '" + name + "' is not a valid Date: " + headerValue);
        }
    }

    private String formatDate(long date) {
        return this.newDateFormat().format(new Date(date));
    }

    private DateFormat newDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        dateFormat.setTimeZone(GMT);
        return dateFormat;
    }

    @Override
    public void setHeader(String name, String value) {
        this.setHeaderValue(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.addHeaderValue(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.setHeaderValue(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.addHeaderValue(name, value);
    }

    private void setHeaderValue(String name, Object value) {
        if (this.setSpecialHeader(name, value)) {
            return;
        }
        this.doAddHeaderValue(name, value, true);
    }

    private void addHeaderValue(String name, Object value) {
        if (this.setSpecialHeader(name, value)) {
            return;
        }
        this.doAddHeaderValue(name, value, false);
    }

    private boolean setSpecialHeader(String name, Object value) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value.toString());
            return true;
        }
        if ("Content-Length".equalsIgnoreCase(name)) {
            this.setContentLength(value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString()));
            return true;
        }
        if ("Content-Language".equalsIgnoreCase(name)) {
            HttpHeaders headers2 = new HttpHeaders();
            headers2.add("Content-Language", value.toString());
            Locale language = headers2.getContentLanguage();
            this.locale = language != null ? language : Locale.getDefault();
            return true;
        }
        return false;
    }

    private void doAddHeaderValue(String name, Object value, boolean replace) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Assert.notNull(value, "Header value must not be null");
        if (header == null) {
            header = new HeaderValueHolder();
            this.headers.put(name, header);
        }
        if (replace) {
            header.setValue(value);
        } else {
            header.addValue(value);
        }
    }

    @Override
    public void setStatus(int status) {
        if (!this.isCommitted()) {
            this.status = status;
        }
    }

    @Override
    @Deprecated
    public void setStatus(int status, String errorMessage) {
        if (!this.isCommitted()) {
            this.status = status;
            this.errorMessage = errorMessage;
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setForwardedUrl(@Nullable String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    @Nullable
    public String getForwardedUrl() {
        return this.forwardedUrl;
    }

    public void setIncludedUrl(@Nullable String includedUrl) {
        this.includedUrls.clear();
        if (includedUrl != null) {
            this.includedUrls.add(includedUrl);
        }
    }

    @Nullable
    public String getIncludedUrl() {
        int count = this.includedUrls.size();
        Assert.state(count <= 1, () -> "More than 1 URL included - check getIncludedUrls instead: " + this.includedUrls);
        return count == 1 ? this.includedUrls.get(0) : null;
    }

    public void addIncludedUrl(String includedUrl) {
        Assert.notNull((Object)includedUrl, "Included URL must not be null");
        this.includedUrls.add(includedUrl);
    }

    public List<String> getIncludedUrls() {
        return this.includedUrls;
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        public ResponsePrintWriter(Writer out) {
            super(out, true);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void write(String s2, int off, int len) {
            super.write(s2, off, len);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void write(int c) {
            super.write(c);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void flush() {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }
    }

    private class ResponseServletOutputStream
    extends DelegatingServletOutputStream {
        public ResponseServletOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }
    }
}

