/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import java.net.URI;
import java.util.List;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class DefaultRequestPath
implements RequestPath {
    private final PathContainer fullPath;
    private final PathContainer contextPath;
    private final PathContainer pathWithinApplication;

    DefaultRequestPath(URI uri, @Nullable String contextPath) {
        this.fullPath = PathContainer.parsePath(uri.getRawPath());
        this.contextPath = DefaultRequestPath.initContextPath(this.fullPath, contextPath);
        this.pathWithinApplication = DefaultRequestPath.extractPathWithinApplication(this.fullPath, this.contextPath);
    }

    private DefaultRequestPath(RequestPath requestPath, String contextPath) {
        this.fullPath = requestPath;
        this.contextPath = DefaultRequestPath.initContextPath(this.fullPath, contextPath);
        this.pathWithinApplication = DefaultRequestPath.extractPathWithinApplication(this.fullPath, this.contextPath);
    }

    private static PathContainer initContextPath(PathContainer path2, @Nullable String contextPath) {
        if (!StringUtils.hasText(contextPath) || "/".equals(contextPath)) {
            return PathContainer.parsePath("");
        }
        DefaultRequestPath.validateContextPath(path2.value(), contextPath);
        int length = contextPath.length();
        int counter = 0;
        for (int i = 0; i < path2.elements().size(); ++i) {
            PathContainer.Element element = path2.elements().get(i);
            if (length != (counter += element.value().length())) continue;
            return path2.subPath(0, i + 1);
        }
        throw new IllegalStateException("Failed to initialize contextPath '" + contextPath + "' for requestPath '" + path2.value() + "'");
    }

    private static void validateContextPath(String fullPath, String contextPath) {
        int length = contextPath.length();
        if (contextPath.charAt(0) != '/' || contextPath.charAt(length - 1) == '/') {
            throw new IllegalArgumentException("Invalid contextPath: '" + contextPath + "': must start with '/' and not end with '/'");
        }
        if (!fullPath.startsWith(contextPath)) {
            throw new IllegalArgumentException("Invalid contextPath '" + contextPath + "': must match the start of requestPath: '" + fullPath + "'");
        }
        if (fullPath.length() > length && fullPath.charAt(length) != '/') {
            throw new IllegalArgumentException("Invalid contextPath '" + contextPath + "': must match to full path segments for requestPath: '" + fullPath + "'");
        }
    }

    private static PathContainer extractPathWithinApplication(PathContainer fullPath, PathContainer contextPath) {
        return fullPath.subPath(contextPath.elements().size());
    }

    @Override
    public String value() {
        return this.fullPath.value();
    }

    @Override
    public List<PathContainer.Element> elements() {
        return this.fullPath.elements();
    }

    @Override
    public PathContainer contextPath() {
        return this.contextPath;
    }

    @Override
    public PathContainer pathWithinApplication() {
        return this.pathWithinApplication;
    }

    @Override
    public RequestPath modifyContextPath(String contextPath) {
        return new DefaultRequestPath(this, contextPath);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DefaultRequestPath that = (DefaultRequestPath)other;
        return this.fullPath.equals(that.fullPath) && this.contextPath.equals(that.contextPath) && this.pathWithinApplication.equals(that.pathWithinApplication);
    }

    public int hashCode() {
        int result = this.fullPath.hashCode();
        result = 31 * result + this.contextPath.hashCode();
        result = 31 * result + this.pathWithinApplication.hashCode();
        return result;
    }

    public String toString() {
        return "DefaultRequestPath[fullPath='" + this.fullPath + "', contextPath='" + this.contextPath.value() + "', pathWithinApplication='" + this.pathWithinApplication.value() + "']";
    }
}

