/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ReactorClientHttpRequest;
import org.springframework.http.client.reactive.ReactorClientHttpResponse;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientOptions;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;

public class ReactorClientHttpConnector
implements ClientHttpConnector {
    private final HttpClient httpClient;

    public ReactorClientHttpConnector() {
        this.httpClient = HttpClient.builder().options(options -> options.compression(true)).build();
    }

    public ReactorClientHttpConnector(Consumer<? super HttpClientOptions.Builder> clientOptions) {
        this.httpClient = HttpClient.create(clientOptions);
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method2, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        if (!uri.isAbsolute()) {
            return Mono.error(new IllegalArgumentException("URI is not absolute: " + uri));
        }
        return this.httpClient.request(this.adaptHttpMethod(method2), uri.toString(), request -> (Mono)requestCallback.apply(this.adaptRequest(method2, uri, (HttpClientRequest)request))).map(this::adaptResponse);
    }

    private io.netty.handler.codec.http.HttpMethod adaptHttpMethod(HttpMethod method2) {
        return io.netty.handler.codec.http.HttpMethod.valueOf(method2.name());
    }

    private ReactorClientHttpRequest adaptRequest(HttpMethod method2, URI uri, HttpClientRequest request) {
        return new ReactorClientHttpRequest(method2, uri, request);
    }

    private ClientHttpResponse adaptResponse(HttpClientResponse response) {
        return new ReactorClientHttpResponse(response);
    }
}

