/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public abstract class OrderUtils {
    @Nullable
    private static Class<? extends Annotation> priorityAnnotationType;

    public static int getOrder(Class<?> type, int defaultOrder) {
        Integer order = OrderUtils.getOrder(type);
        return order != null ? order : defaultOrder;
    }

    @Nullable
    public static Integer getOrder(Class<?> type, @Nullable Integer defaultOrder) {
        Integer order = OrderUtils.getOrder(type);
        return order != null ? order : defaultOrder;
    }

    @Nullable
    public static Integer getOrder(Class<?> type) {
        Order order = AnnotationUtils.findAnnotation(type, Order.class);
        if (order != null) {
            return order.value();
        }
        Integer priorityOrder = OrderUtils.getPriority(type);
        if (priorityOrder != null) {
            return priorityOrder;
        }
        return null;
    }

    @Nullable
    public static Integer getPriority(Class<?> type) {
        Annotation priority;
        if (priorityAnnotationType != null && (priority = AnnotationUtils.findAnnotation(type, priorityAnnotationType)) != null) {
            return (Integer)AnnotationUtils.getValue(priority);
        }
        return null;
    }

    static {
        try {
            priorityAnnotationType = ClassUtils.forName("javax.annotation.Priority", OrderUtils.class.getClassLoader());
        }
        catch (Throwable ex) {
            priorityAnnotationType = null;
        }
    }
}

