/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.cloud.client.loadbalancer.RetryableStatusCodeException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpResponse;

public class ClientHttpResponseStatusCodeException
extends RetryableStatusCodeException {
    private ClientHttpResponseWrapper response;

    public ClientHttpResponseStatusCodeException(String serviceId, ClientHttpResponse response, byte[] body2) throws IOException {
        super(serviceId, response.getRawStatusCode(), response, null);
        this.response = new ClientHttpResponseWrapper(response, body2);
    }

    @Override
    public ClientHttpResponse getResponse() {
        return this.response;
    }

    static class ClientHttpResponseWrapper
    extends AbstractClientHttpResponse {
        private ClientHttpResponse response;
        private byte[] body;

        public ClientHttpResponseWrapper(ClientHttpResponse response, byte[] body2) {
            this.response = response;
            this.body = body2;
        }

        @Override
        public int getRawStatusCode() throws IOException {
            return this.response.getRawStatusCode();
        }

        @Override
        public String getStatusText() throws IOException {
            return this.response.getStatusText();
        }

        @Override
        public void close() {
            this.response.close();
        }

        @Override
        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.body);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }
    }
}

