/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import java.util.List;
import org.springframework.cloud.client.hypermedia.RemoteResource;
import org.springframework.scheduling.config.ContextLifecycleScheduledTaskRegistrar;
import org.springframework.scheduling.config.IntervalTask;

public class RemoteResourceRefresher
extends ContextLifecycleScheduledTaskRegistrar {
    private final List<RemoteResource> discoveredResources;
    private final int fixedDelay;
    private final int initialDelay;

    public RemoteResourceRefresher(List<RemoteResource> discoveredResources, int fixedDelay, int initialDelay) {
        this.discoveredResources = discoveredResources;
        this.fixedDelay = fixedDelay;
        this.initialDelay = initialDelay;
    }

    @Override
    public void afterPropertiesSet() {
        for (final RemoteResource resource : this.discoveredResources) {
            this.addFixedDelayTask(new IntervalTask(new Runnable(){

                @Override
                public void run() {
                    resource.verifyOrDiscover();
                }
            }, this.fixedDelay, this.initialDelay));
        }
        super.afterPropertiesSet();
    }
}

