/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.lang.reflect.Method;
import org.apache.catalina.Context;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TomcatErrorPage {
    private static final String ERROR_PAGE_CLASS = "org.apache.tomcat.util.descriptor.web.ErrorPage";
    private final String location;
    private final String exceptionType;
    private final int errorCode;
    private final Object nativePage;

    TomcatErrorPage(org.springframework.boot.web.server.ErrorPage errorPage) {
        this.location = errorPage.getPath();
        this.exceptionType = errorPage.getExceptionName();
        this.errorCode = errorPage.getStatusCode();
        this.nativePage = this.createNativePage();
    }

    private Object createNativePage() {
        try {
            if (ClassUtils.isPresent(ERROR_PAGE_CLASS, null)) {
                return BeanUtils.instantiateClass(ClassUtils.forName(ERROR_PAGE_CLASS, null));
            }
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            // empty catch block
        }
        return null;
    }

    public void addToContext(Context context) {
        Assert.state(this.nativePage != null, "No Tomcat 8 detected so no native error page exists");
        if (ClassUtils.isPresent(ERROR_PAGE_CLASS, null)) {
            ErrorPage errorPage = (ErrorPage)this.nativePage;
            errorPage.setLocation(this.location);
            errorPage.setErrorCode(this.errorCode);
            errorPage.setExceptionType(this.exceptionType);
            context.addErrorPage(errorPage);
        } else {
            this.callMethod(this.nativePage, "setLocation", this.location, String.class);
            this.callMethod(this.nativePage, "setErrorCode", this.errorCode, Integer.TYPE);
            this.callMethod(this.nativePage, "setExceptionType", this.exceptionType, String.class);
            this.callMethod(context, "addErrorPage", this.nativePage, this.nativePage.getClass());
        }
    }

    private void callMethod(Object target, String name, Object value, Class<?> type) {
        Method method2 = ReflectionUtils.findMethod(target.getClass(), name, type);
        ReflectionUtils.invokeMethod(method2, target, value);
    }
}

