/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import reactor.ipc.netty.http.HttpResources;
import reactor.ipc.netty.http.server.HttpServer;
import reactor.ipc.netty.tcp.BlockingNettyContext;

public class NettyWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(NettyWebServer.class);
    private final HttpServer httpServer;
    private final ReactorHttpHandlerAdapter handlerAdapter;
    private final Duration lifecycleTimeout;
    private BlockingNettyContext nettyContext;

    public NettyWebServer(HttpServer httpServer, ReactorHttpHandlerAdapter handlerAdapter, Duration lifecycleTimeout) {
        Assert.notNull((Object)httpServer, "HttpServer must not be null");
        Assert.notNull((Object)handlerAdapter, "HandlerAdapter must not be null");
        this.httpServer = httpServer;
        this.handlerAdapter = handlerAdapter;
        this.lifecycleTimeout = lifecycleTimeout;
    }

    @Override
    public void start() throws WebServerException {
        if (this.nettyContext == null) {
            try {
                this.nettyContext = this.startHttpServer();
            }
            catch (Exception ex) {
                SocketAddress address;
                if (this.findBindException(ex) != null && (address = this.httpServer.options().getAddress()) instanceof InetSocketAddress) {
                    throw new PortInUseException(((InetSocketAddress)address).getPort());
                }
                throw new WebServerException("Unable to start Netty", ex);
            }
            logger.info("Netty started on port(s): " + this.getPort());
            this.startDaemonAwaitThread(this.nettyContext);
        }
    }

    private BlockingNettyContext startHttpServer() {
        if (this.lifecycleTimeout != null) {
            return this.httpServer.start(this.handlerAdapter, this.lifecycleTimeout);
        }
        return this.httpServer.start(this.handlerAdapter);
    }

    private BindException findBindException(Exception ex) {
        for (Throwable candidate = ex; candidate != null; candidate = candidate.getCause()) {
            if (!(candidate instanceof BindException)) continue;
            return (BindException)candidate;
        }
        return null;
    }

    private void startDaemonAwaitThread(final BlockingNettyContext nettyContext) {
        Thread awaitThread = new Thread("server"){

            @Override
            public void run() {
                nettyContext.getContext().onClose().block();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    @Override
    public void stop() throws WebServerException {
        if (this.nettyContext != null) {
            this.nettyContext.shutdown();
            this.nettyContext.getContext().onClose().doOnSuccess(o -> HttpResources.reset()).block();
            this.nettyContext = null;
        }
    }

    @Override
    public int getPort() {
        if (this.nettyContext != null) {
            return this.nettyContext.getPort();
        }
        return 0;
    }
}

