/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jta.narayana;

import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.transaction.TransactionManager;
import org.jboss.narayana.jta.jms.ConnectionFactoryProxy;
import org.jboss.narayana.jta.jms.JmsXAResourceRecoveryHelper;
import org.jboss.narayana.jta.jms.TransactionHelper;
import org.jboss.narayana.jta.jms.TransactionHelperImpl;
import org.springframework.boot.jms.XAConnectionFactoryWrapper;
import org.springframework.boot.jta.narayana.NarayanaProperties;
import org.springframework.boot.jta.narayana.NarayanaRecoveryManagerBean;
import org.springframework.util.Assert;

public class NarayanaXAConnectionFactoryWrapper
implements XAConnectionFactoryWrapper {
    private final TransactionManager transactionManager;
    private final NarayanaRecoveryManagerBean recoveryManager;
    private final NarayanaProperties properties;

    public NarayanaXAConnectionFactoryWrapper(TransactionManager transactionManager, NarayanaRecoveryManagerBean recoveryManager, NarayanaProperties properties) {
        Assert.notNull((Object)transactionManager, "TransactionManager must not be null");
        Assert.notNull((Object)recoveryManager, "RecoveryManager must not be null");
        Assert.notNull((Object)properties, "Properties must not be null");
        this.transactionManager = transactionManager;
        this.recoveryManager = recoveryManager;
        this.properties = properties;
    }

    @Override
    public ConnectionFactory wrapConnectionFactory(XAConnectionFactory xaConnectionFactory) {
        XAResourceRecoveryHelper recoveryHelper = this.getRecoveryHelper(xaConnectionFactory);
        this.recoveryManager.registerXAResourceRecoveryHelper(recoveryHelper);
        return new ConnectionFactoryProxy(xaConnectionFactory, (TransactionHelper)new TransactionHelperImpl(this.transactionManager));
    }

    private XAResourceRecoveryHelper getRecoveryHelper(XAConnectionFactory xaConnectionFactory) {
        if (this.properties.getRecoveryJmsUser() == null && this.properties.getRecoveryJmsPass() == null) {
            return new JmsXAResourceRecoveryHelper(xaConnectionFactory);
        }
        return new JmsXAResourceRecoveryHelper(xaConnectionFactory, this.properties.getRecoveryJmsUser(), this.properties.getRecoveryJmsPass());
    }
}

