/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jta.bitronix;

import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jms.PoolingConnectionFactory;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.jta.bitronix.connectionfactory")
public class PoolingConnectionFactoryBean
extends PoolingConnectionFactory
implements BeanNameAware,
InitializingBean,
DisposableBean {
    private static final ThreadLocal<PoolingConnectionFactoryBean> source = new ThreadLocal();
    private String beanName;
    private XAConnectionFactory connectionFactory;

    public PoolingConnectionFactoryBean() {
        this.setMaxPoolSize(10);
        this.setTestConnections(true);
        this.setAutomaticEnlistingEnabled(true);
        this.setAllowLocalTransactions(true);
    }

    public synchronized void init() {
        source.set(this);
        try {
            super.init();
        }
        finally {
            source.remove();
        }
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasLength(this.getUniqueName())) {
            this.setUniqueName(this.beanName);
        }
        this.init();
    }

    @Override
    public void destroy() throws Exception {
        this.close();
    }

    public void setConnectionFactory(XAConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.setClassName(DirectXAConnectionFactory.class.getName());
        this.setDriverProperties(new Properties());
    }

    protected final XAConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public XAStatefulHolder createPooledConnection(Object xaFactory, ResourceBean bean2) throws Exception {
        if (xaFactory instanceof DirectXAConnectionFactory) {
            xaFactory = ((DirectXAConnectionFactory)xaFactory).getConnectionFactory();
        }
        return super.createPooledConnection(xaFactory, bean2);
    }

    static /* synthetic */ ThreadLocal access$000() {
        return source;
    }

    static /* synthetic */ XAConnectionFactory access$100(PoolingConnectionFactoryBean x0) {
        return x0.connectionFactory;
    }

    public static class DirectXAConnectionFactory
    implements XAConnectionFactory {
        private final XAConnectionFactory connectionFactory = PoolingConnectionFactoryBean.access$100((PoolingConnectionFactoryBean)PoolingConnectionFactoryBean.access$000().get());

        public XAConnection createXAConnection() throws JMSException {
            return this.connectionFactory.createXAConnection();
        }

        public XAConnection createXAConnection(String userName, String password) throws JMSException {
            return this.connectionFactory.createXAConnection(userName, password);
        }

        public XAConnectionFactory getConnectionFactory() {
            return this.connectionFactory;
        }

        public XAJMSContext createXAContext() {
            return this.connectionFactory.createXAContext();
        }

        public XAJMSContext createXAContext(String username, String password) {
            return this.connectionFactory.createXAContext(username, password);
        }
    }
}

