/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.origin.SystemEnvironmentOrigin;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;

public class SystemEnvironmentPropertySourceEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int DEFAULT_ORDER = -2147483644;
    private int order = -2147483644;

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        String sourceName = "systemEnvironment";
        PropertySource<?> propertySource = environment2.getPropertySources().get(sourceName);
        if (propertySource != null) {
            this.replacePropertySource(environment2, sourceName, propertySource);
        }
    }

    private void replacePropertySource(ConfigurableEnvironment environment2, String sourceName, PropertySource<?> propertySource) {
        Map originalSource = (Map)propertySource.getSource();
        OriginAwareSystemEnvironmentPropertySource source = new OriginAwareSystemEnvironmentPropertySource(sourceName, originalSource);
        environment2.getPropertySources().replace(sourceName, source);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    protected static class OriginAwareSystemEnvironmentPropertySource
    extends SystemEnvironmentPropertySource
    implements OriginLookup<String> {
        OriginAwareSystemEnvironmentPropertySource(String name, Map<String, Object> source) {
            super(name, source);
        }

        @Override
        public Origin getOrigin(String key) {
            String property = this.resolvePropertyName(key);
            if (super.containsProperty(property)) {
                return new SystemEnvironmentOrigin(property);
            }
            return null;
        }
    }
}

