/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ConfigurationBeanFactoryMetadata
implements BeanFactoryPostProcessor {
    public static final String BEAN_NAME = ConfigurationBeanFactoryMetadata.class.getName();
    private ConfigurableListableBeanFactory beanFactory;
    private final Map<String, FactoryMetadata> beansFactoryMetadata = new HashMap<String, FactoryMetadata>();

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        for (String name : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(name);
            String method2 = definition.getFactoryMethodName();
            String bean2 = definition.getFactoryBeanName();
            if (method2 == null || bean2 == null) continue;
            this.beansFactoryMetadata.put(name, new FactoryMetadata(bean2, method2));
        }
    }

    public <A extends Annotation> Map<String, Object> getBeansWithFactoryAnnotation(Class<A> type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String name : this.beansFactoryMetadata.keySet()) {
            if (this.findFactoryAnnotation(name, type) == null) continue;
            result.put(name, this.beanFactory.getBean(name));
        }
        return result;
    }

    public <A extends Annotation> A findFactoryAnnotation(String beanName, Class<A> type) {
        Method method2 = this.findFactoryMethod(beanName);
        return method2 != null ? (A)AnnotationUtils.findAnnotation(method2, type) : null;
    }

    public Method findFactoryMethod(String beanName) {
        if (!this.beansFactoryMetadata.containsKey(beanName)) {
            return null;
        }
        AtomicReference<Object> found = new AtomicReference<Object>(null);
        FactoryMetadata metadata = this.beansFactoryMetadata.get(beanName);
        Class<?> factoryType = this.beanFactory.getType(metadata.getBean());
        String factoryMethod = metadata.getMethod();
        if (ClassUtils.isCglibProxyClass(factoryType)) {
            factoryType = factoryType.getSuperclass();
        }
        ReflectionUtils.doWithMethods(factoryType, method2 -> {
            if (method2.getName().equals(factoryMethod)) {
                found.compareAndSet(null, method2);
            }
        });
        return found.get();
    }

    private static class FactoryMetadata {
        private final String bean;
        private final String method;

        FactoryMetadata(String bean2, String method2) {
            this.bean = bean2;
            this.method = method2;
        }

        public String getBean() {
            return this.bean;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

