/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.util.List;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.springframework.boot.jdbc.SchemaManagement;
import org.springframework.boot.jdbc.SchemaManagementProvider;

class FlywaySchemaManagementProvider
implements SchemaManagementProvider {
    private final List<Flyway> flywayInstances;

    FlywaySchemaManagementProvider(List<Flyway> flywayInstances) {
        this.flywayInstances = flywayInstances;
    }

    @Override
    public SchemaManagement getSchemaManagement(DataSource dataSource) {
        for (Flyway flywayInstance : this.flywayInstances) {
            if (!dataSource.equals(flywayInstance.getDataSource())) continue;
            return SchemaManagement.MANAGED;
        }
        return SchemaManagement.UNMANAGED;
    }
}

