/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.jersey;

import java.util.Collections;
import java.util.List;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jersey.ResourceConfigCustomizer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ManagementContextConfiguration(value=ManagementContextType.CHILD)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={ResourceConfig.class})
@ConditionalOnMissingClass(value={"org.springframework.web.servlet.DispatcherServlet"})
public class JerseyManagementChildContextConfiguration {
    private final List<ResourceConfigCustomizer> resourceConfigCustomizers;

    public JerseyManagementChildContextConfiguration(ObjectProvider<List<ResourceConfigCustomizer>> resourceConfigCustomizers) {
        this.resourceConfigCustomizers = resourceConfigCustomizers.getIfAvailable(Collections::emptyList);
    }

    @Bean
    public ServletRegistrationBean<ServletContainer> jerseyServletRegistration() {
        return new ServletRegistrationBean<ServletContainer>(new ServletContainer(this.endpointResourceConfig()), "/*");
    }

    @Bean
    public ResourceConfig endpointResourceConfig() {
        ResourceConfig resourceConfig = new ResourceConfig();
        for (ResourceConfigCustomizer customizer2 : this.resourceConfigCustomizers) {
            customizer2.customize(resourceConfig);
        }
        return resourceConfig;
    }
}

