/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.logging;

import org.springframework.boot.actuate.autoconfigure.logging.LogFileWebEndpointProperties;
import org.springframework.boot.actuate.logging.LogFileWebEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={LogFileWebEndpointProperties.class})
public class LogFileWebEndpointAutoConfiguration {
    private final LogFileWebEndpointProperties properties;

    public LogFileWebEndpointAutoConfiguration(LogFileWebEndpointProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={LogFileCondition.class})
    public LogFileWebEndpoint logFileWebEndpoint(Environment environment2) {
        return new LogFileWebEndpoint(environment2, this.properties.getExternalFile());
    }

    private static class LogFileCondition
    extends SpringBootCondition {
        private LogFileCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment2 = context.getEnvironment();
            String config = environment2.resolvePlaceholders("${logging.file:}");
            ConditionMessage.Builder message = ConditionMessage.forCondition("Log File", new Object[0]);
            if (StringUtils.hasText(config)) {
                return ConditionOutcome.match(message.found("logging.file").items(config));
            }
            config = environment2.resolvePlaceholders("${logging.path:}");
            if (StringUtils.hasText(config)) {
                return ConditionOutcome.match(message.found("logging.path").items(config));
            }
            config = environment2.getProperty("management.endpoint.logfile.external-file");
            if (StringUtils.hasText(config)) {
                return ConditionOutcome.match(message.found("management.endpoint.logfile.external-file").items(config));
            }
            return ConditionOutcome.noMatch(message.didNotFind("logging file").atAll());
        }
    }
}

