/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationMappingImpl;
import org.apache.catalina.mapper.MappingData;

public class ApplicationMapping {
    private final MappingData mappingData;
    private volatile ApplicationMappingImpl mapping = null;

    public ApplicationMapping(MappingData mappingData) {
        this.mappingData = mappingData;
    }

    public ApplicationMappingImpl getHttpServletMapping() {
        if (this.mapping == null) {
            if (this.mappingData == null) {
                this.mapping = new ApplicationMappingImpl("", "", null, "");
            } else {
                String servletName = this.mappingData.wrapper == null ? "" : this.mappingData.wrapper.getName();
                if (this.mappingData.matchType == null) {
                    this.mapping = new ApplicationMappingImpl("", "", null, servletName);
                } else {
                    switch (this.mappingData.matchType) {
                        case CONTEXT_ROOT: {
                            this.mapping = new ApplicationMappingImpl("", "", this.mappingData.matchType, servletName);
                            break;
                        }
                        case DEFAULT: {
                            this.mapping = new ApplicationMappingImpl("", "/", this.mappingData.matchType, servletName);
                            break;
                        }
                        case EXACT: {
                            this.mapping = new ApplicationMappingImpl(this.mappingData.wrapperPath.toString().substring(1), this.mappingData.wrapperPath.toString(), this.mappingData.matchType, servletName);
                            break;
                        }
                        case EXTENSION: {
                            String path2 = this.mappingData.wrapperPath.toString();
                            int extIndex = path2.lastIndexOf(46);
                            this.mapping = new ApplicationMappingImpl(path2.substring(1, extIndex), "*" + path2.substring(extIndex), this.mappingData.matchType, servletName);
                            break;
                        }
                        case PATH: {
                            String matchValue = this.mappingData.pathInfo.isNull() ? null : this.mappingData.pathInfo.toString().substring(1);
                            this.mapping = new ApplicationMappingImpl(matchValue, this.mappingData.wrapperPath.toString() + "/*", this.mappingData.matchType, servletName);
                        }
                    }
                }
            }
        }
        return this.mapping;
    }

    public void recycle() {
        this.mapping = null;
    }

    public static ApplicationMappingImpl getHttpServletMapping(HttpServletRequest request) {
        if (request instanceof RequestFacade) {
            return ((RequestFacade)request).getHttpServletMapping();
        }
        if (request instanceof Request) {
            return ((Request)request).getHttpServletMapping();
        }
        if (request instanceof ApplicationHttpRequest) {
            return ((ApplicationHttpRequest)request).getHttpServletMapping();
        }
        return new ApplicationMapping(null).getHttpServletMapping();
    }

    public static ApplicationMappingImpl getHttpServletMapping(HttpServletRequestWrapper wrapper) {
        if (wrapper instanceof ApplicationHttpRequest) {
            return ((ApplicationHttpRequest)wrapper).getHttpServletMapping();
        }
        return new ApplicationMapping(null).getHttpServletMapping();
    }
}

