/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.helper;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.mosip.kernel.auth.defaultadapter.constant.AuthAdapterErrorCode;
import io.mosip.kernel.core.authmanager.authadapter.model.MosipUserDto;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.util.DateUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class ValidateTokenHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateTokenHelper.class);
    private Map<String, PublicKey> publicKeys = new HashMap<String, PublicKey>();
    @Value(value="${auth.server.admin.oidc.certs.path:/protocol/openid-connect/certs}")
    private String certsPath;
    @Value(value="${auth.server.admin.oidc.userinfo.path:/protocol/openid-connect/userinfo}")
    private String userInfo;
    @Value(value="${auth.server.admin.issuer.domain.validate:true}")
    private boolean validateIssuerDomain;
    @Value(value="${auth.server.admin.issuer.uri:}")
    private String issuerURI;
    @Value(value="${auth.server.admin.audience.claim.validate:true}")
    private boolean validateAudClaim;
    private List<String> allowedAudience;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private Environment environment;

    @PostConstruct
    private void init() {
        String applName = this.getApplicationName();
        this.allowedAudience = this.environment.getProperty("auth.server.admin.allowed.audience." + applName, List.class, this.environment.getProperty("auth.server.admin.allowed.audience", List.class, Collections.EMPTY_LIST));
    }

    private String getApplicationName() {
        String appNames = this.environment.getProperty("spring.application.name");
        List appNamesList = Stream.of(appNames.split(",")).collect(Collectors.toList());
        return (String)appNamesList.get(0);
    }

    public MosipUserDto doOfflineLocalTokenValidation(String jwtToken) {
        LOGGER.info("offline verification for local profile.");
        DecodedJWT decodedJWT = JWT.require((Algorithm)Algorithm.none()).build().verify(jwtToken);
        return this.buildMosipUser(decodedJWT, jwtToken);
    }

    public ImmutablePair<Boolean, AuthAdapterErrorCode> isTokenValid(DecodedJWT decodedJWT, PublicKey publicKey) {
        LocalDateTime expiryTime = DateUtils.convertUTCToLocalDateTime((String)DateUtils.getUTCTimeFromDate((Date)decodedJWT.getExpiresAt()));
        String userName = decodedJWT.getClaim("preferred_username").asString();
        if (!DateUtils.before((LocalDateTime)DateUtils.getUTCCurrentDateTime(), (LocalDateTime)expiryTime)) {
            LOGGER.error("Provided Auth Token expired. Throwing Authentication Exception. UserName: " + userName);
            return ImmutablePair.of((Object)Boolean.FALSE, (Object)((Object)AuthAdapterErrorCode.UNAUTHORIZED));
        }
        boolean tokenDomainMatch = this.getTokenIssuerDomain(decodedJWT);
        if (this.validateIssuerDomain && !tokenDomainMatch) {
            LOGGER.error("Provided Auth Token Issue domain does not match. Throwing Authentication Exception. UserName: " + userName);
            return ImmutablePair.of((Object)Boolean.FALSE, (Object)((Object)AuthAdapterErrorCode.UNAUTHORIZED));
        }
        try {
            String tokenAlgo = decodedJWT.getAlgorithm();
            Algorithm algorithm = this.getVerificationAlgorithm(tokenAlgo, publicKey);
            algorithm.verify(decodedJWT);
        }
        catch (SignatureVerificationException signatureException) {
            LOGGER.error("Signature validation failed, Throwing Authentication Exception. UserName: " + userName, signatureException);
            return ImmutablePair.of((Object)Boolean.FALSE, (Object)((Object)AuthAdapterErrorCode.UNAUTHORIZED));
        }
        boolean matchFound = this.validateAudience(decodedJWT);
        if (!matchFound) {
            LOGGER.error("Provided Client Id does not match with Aud/AZP. Throwing Authorizaion Exception. UserName: " + userName);
            return ImmutablePair.of((Object)Boolean.FALSE, (Object)((Object)AuthAdapterErrorCode.FORBIDDEN));
        }
        return ImmutablePair.of((Object)Boolean.TRUE, null);
    }

    private boolean validateAudience(DecodedJWT decodedJWT) {
        boolean matchFound = false;
        if (this.validateAudClaim) {
            List tokenAudience = decodedJWT.getAudience();
            matchFound = tokenAudience.stream().anyMatch(this.allowedAudience::contains);
            String azp = decodedJWT.getClaim("azp").asString();
            if (!matchFound) {
                matchFound = this.allowedAudience.stream().anyMatch(azp::equalsIgnoreCase);
            }
        }
        return matchFound;
    }

    private boolean getTokenIssuerDomain(DecodedJWT decodedJWT) {
        String domain = decodedJWT.getClaim("iss").asString();
        try {
            String tokenHost = new URI(domain).getHost();
            String issuerHost = new URI(this.issuerURI).getHost();
            return tokenHost.equalsIgnoreCase(issuerHost);
        }
        catch (URISyntaxException synExp) {
            LOGGER.error("Unable to parse domain from issuer.", synExp);
            return false;
        }
    }

    public PublicKey getPublicKey(DecodedJWT decodedJWT) {
        String userName = decodedJWT.getClaim("preferred_username").asString();
        LOGGER.info("offline verification for environment profile. UserName: " + userName);
        String keyId = decodedJWT.getKeyId();
        PublicKey publicKey = this.publicKeys.get(keyId);
        if (Objects.isNull(publicKey)) {
            String realm = this.getRealM(decodedJWT);
            publicKey = this.getIssuerPublicKey(keyId, this.certsPath, realm);
            this.publicKeys.put(keyId, publicKey);
        }
        return publicKey;
    }

    private String getRealM(DecodedJWT decodedJWT) {
        String tokenIssuer = decodedJWT.getClaim("iss").asString();
        return tokenIssuer.substring(tokenIssuer.lastIndexOf("/") + 1);
    }

    private PublicKey getIssuerPublicKey(String keyId, String certsPath, String realm) {
        try {
            URI uri = new URI(this.issuerURI + realm + certsPath).normalize();
            UrlJwkProvider provider = new UrlJwkProvider(uri.toURL());
            Jwk jwk = provider.get(keyId);
            return jwk.getPublicKey();
        }
        catch (JwkException | MalformedURLException | URISyntaxException e) {
            LOGGER.error("Error downloading Public key from server".concat(e.getMessage()));
            return null;
        }
    }

    private Algorithm getVerificationAlgorithm(String tokenAlgo, PublicKey publicKey) {
        switch (tokenAlgo) {
            case "RS256": {
                return Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
            }
            case "RS384": {
                return Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)publicKey), null);
            }
            case "RS512": {
                return Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)publicKey), null);
            }
        }
        return Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
    }

    public MosipUserDto buildMosipUser(DecodedJWT decodedJWT, String jwtToken) {
        MosipUserDto mosipUserDto = new MosipUserDto();
        String user = decodedJWT.getSubject();
        mosipUserDto.setToken(jwtToken);
        mosipUserDto.setMail(decodedJWT.getClaim("email").asString());
        mosipUserDto.setMobile(decodedJWT.getClaim("mobile").asString());
        mosipUserDto.setUserId(decodedJWT.getClaim("preferred_username").asString());
        Claim realmAccess = decodedJWT.getClaim("realm_access");
        if (!realmAccess.isNull()) {
            List roles = (List)realmAccess.asMap().get("roles");
            StringBuilder strBuilder = new StringBuilder();
            for (String role : roles) {
                strBuilder.append(role);
                strBuilder.append(",");
            }
            mosipUserDto.setRole(strBuilder.toString());
            mosipUserDto.setName(user);
        } else {
            mosipUserDto.setRole(decodedJWT.getClaim("roles").asString());
            mosipUserDto.setName(user);
        }
        LOGGER.info("user (offline verification done): " + mosipUserDto.getUserId());
        return mosipUserDto;
    }

    public ImmutablePair<HttpStatus, MosipUserDto> doOnlineTokenValidation(String jwtToken, RestTemplate restTemplate) {
        if ("".equals(this.issuerURI)) {
            LOGGER.warn("OIDC validate URL is not available in config file, not requesting for token validation.");
            return ImmutablePair.of((Object)((Object)HttpStatus.EXPECTATION_FAILED), null);
        }
        DecodedJWT decodedJWT = JWT.decode((String)jwtToken);
        HttpHeaders headers2 = new HttpHeaders();
        headers2.add("Authorization", "Bearer " + jwtToken);
        HttpEntity<String> entity = new HttpEntity<String>("parameters", headers2);
        ResponseEntity<String> response = null;
        HttpStatusCodeException statusCodeException = null;
        try {
            String realm = this.getRealM(decodedJWT);
            String userInfoPath = this.issuerURI + realm + this.userInfo;
            response = restTemplate.exchange(userInfoPath, HttpMethod.GET, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            LOGGER.error("Token validation failed for accessToken {}", (Object)jwtToken, (Object)e);
            statusCodeException = e;
        }
        if (Objects.nonNull(statusCodeException)) {
            try {
                JsonNode errorNode = this.objectMapper.readTree(statusCodeException.getResponseBodyAsString());
                LOGGER.error("Token validation failed error {} and message {}", (Object)errorNode.get("error"), (Object)errorNode.get("error_description"));
                return ImmutablePair.of((Object)((Object)statusCodeException.getStatusCode()), null);
            }
            catch (IOException e) {
                LOGGER.error("IO Excepton in parsing response {}", (Object)e.getMessage());
            }
        }
        if (response.getStatusCode().is2xxSuccessful()) {
            boolean matchFound = this.validateAudience(decodedJWT);
            if (!matchFound) {
                LOGGER.error("Provided Client Id does not match with Aud/AZP. Throwing Authorizaion Exception");
                return ImmutablePair.of((Object)((Object)HttpStatus.FORBIDDEN), null);
            }
            MosipUserDto mosipUserDto = this.buildMosipUser(decodedJWT, jwtToken);
            return ImmutablePair.of((Object)((Object)HttpStatus.OK), (Object)mosipUserDto);
        }
        return ImmutablePair.of((Object)((Object)HttpStatus.UNAUTHORIZED), null);
    }

    public ImmutablePair<HttpStatus, MosipUserDto> doOnlineTokenValidation(String jwtToken, WebClient webClient) {
        if ("".equals(this.issuerURI)) {
            LOGGER.warn("OIDC validate URL is not available in config file, not requesting for token validation.");
            return ImmutablePair.of((Object)((Object)HttpStatus.EXPECTATION_FAILED), null);
        }
        DecodedJWT decodedJWT = JWT.decode((String)jwtToken);
        HttpHeaders headers2 = new HttpHeaders();
        headers2.add("Authorization", "Bearer " + jwtToken);
        String realm = this.getRealM(decodedJWT);
        String userInfoPath = this.issuerURI + realm + this.userInfo;
        ClientResponse response = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.method(HttpMethod.GET).uri(userInfoPath, new Object[0])).headers(httpHeaders -> httpHeaders.addAll(headers2))).exchange().block();
        if (response.statusCode() == HttpStatus.OK) {
            ObjectNode responseBody = response.bodyToMono(ObjectNode.class).block();
            List validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody.asText());
            if (!validationErrorsList.isEmpty()) {
                LOGGER.error("Error in validate token. Code {}, message {}", (Object)((ServiceError)validationErrorsList.get(0)).getErrorCode(), (Object)((ServiceError)validationErrorsList.get(0)).getMessage());
                return ImmutablePair.of((Object)((Object)HttpStatus.UNAUTHORIZED), null);
            }
            boolean matchFound = this.validateAudience(decodedJWT);
            if (!matchFound) {
                LOGGER.error("Provided Client Id does not match with Aud/AZP. Throwing Authorizaion Exception");
                return ImmutablePair.of((Object)((Object)HttpStatus.FORBIDDEN), null);
            }
            MosipUserDto mosipUserDto = this.buildMosipUser(decodedJWT, jwtToken);
            return ImmutablePair.of((Object)((Object)HttpStatus.OK), (Object)mosipUserDto);
        }
        LOGGER.error("user authentication failed for the provided token (WebClient).");
        return ImmutablePair.of((Object)((Object)HttpStatus.UNAUTHORIZED), null);
    }
}

