/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.helper;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.mosip.kernel.auth.defaultadapter.constant.AuthAdapterErrorCode;
import io.mosip.kernel.auth.defaultadapter.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultadapter.helper.ValidateTokenHelper;
import io.mosip.kernel.core.authmanager.authadapter.model.MosipUserDto;
import java.security.PublicKey;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class TokenValidationHelper {
    @Value(value="${auth.server.admin.offline.comp.token.validate:true}")
    private boolean offlineTokenValidate;
    @Value(value="${spring.profiles.active:}")
    String activeProfile;
    @Value(value="${auth.server.admin.certs.path:/protocol/openid-connect/certs}")
    String certsPath;
    @Autowired
    private ValidateTokenHelper validateTokenHelper;

    public MosipUserDto getTokenValidatedUserResponse(String token, RestTemplate restTemplate) {
        if (!this.offlineTokenValidate) {
            return this.doOnlineTokenValidation(token, restTemplate);
        }
        return this.doOfflineTokenValidation(token, restTemplate);
    }

    public MosipUserDto getOnlineTokenValidatedUserResponse(String token, RestTemplate restTemplate) {
        return this.doOnlineTokenValidation(token, restTemplate);
    }

    private MosipUserDto doOnlineTokenValidation(String token, RestTemplate restTemplate) {
        ImmutablePair<HttpStatus, MosipUserDto> validateResp = this.validateTokenHelper.doOnlineTokenValidation(token, restTemplate);
        if (validateResp.getLeft() == HttpStatus.EXPECTATION_FAILED || validateResp.getLeft() == HttpStatus.UNAUTHORIZED) {
            throw new AuthManagerException(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), AuthAdapterErrorCode.UNAUTHORIZED.getErrorMessage());
        }
        if (validateResp.getLeft() == HttpStatus.FORBIDDEN) {
            throw new AuthManagerException(AuthAdapterErrorCode.FORBIDDEN.getErrorCode(), AuthAdapterErrorCode.FORBIDDEN.getErrorMessage());
        }
        if (validateResp.getLeft() != HttpStatus.OK) {
            throw new AuthManagerException(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), AuthAdapterErrorCode.UNAUTHORIZED.getErrorMessage());
        }
        return (MosipUserDto)validateResp.getRight();
    }

    private MosipUserDto doOfflineTokenValidation(String token, RestTemplate restTemplate) {
        if (this.activeProfile.equalsIgnoreCase("local")) {
            return this.validateTokenHelper.doOfflineLocalTokenValidation(token);
        }
        return this.doOfflineEnvTokenValidation(token, restTemplate);
    }

    private MosipUserDto doOfflineEnvTokenValidation(String jwtToken, RestTemplate restTemplate) {
        DecodedJWT decodedJWT = JWT.decode((String)jwtToken);
        PublicKey publicKey = this.validateTokenHelper.getPublicKey(decodedJWT);
        if (Objects.isNull(publicKey)) {
            return this.doOnlineTokenValidation(jwtToken, restTemplate);
        }
        ImmutablePair<Boolean, AuthAdapterErrorCode> validateResp = this.validateTokenHelper.isTokenValid(decodedJWT, publicKey);
        if (validateResp.getLeft() == Boolean.FALSE) {
            throw new AuthManagerException(((AuthAdapterErrorCode)((Object)validateResp.getRight())).getErrorCode(), ((AuthAdapterErrorCode)((Object)validateResp.getRight())).getErrorMessage());
        }
        return this.validateTokenHelper.buildMosipUser(decodedJWT, jwtToken);
    }

    public MosipUserDto doOnlineTokenValidation(String token, WebClient webClient) {
        ImmutablePair<HttpStatus, MosipUserDto> validateResp = this.validateTokenHelper.doOnlineTokenValidation(token, webClient);
        if (validateResp.getLeft() == HttpStatus.EXPECTATION_FAILED || validateResp.getLeft() == HttpStatus.UNAUTHORIZED) {
            throw new AuthManagerException(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), AuthAdapterErrorCode.UNAUTHORIZED.getErrorMessage());
        }
        if (validateResp.getLeft() == HttpStatus.FORBIDDEN) {
            throw new AuthManagerException(AuthAdapterErrorCode.FORBIDDEN.getErrorCode(), AuthAdapterErrorCode.FORBIDDEN.getErrorMessage());
        }
        if (validateResp.getLeft() != HttpStatus.OK) {
            throw new AuthManagerException(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), AuthAdapterErrorCode.UNAUTHORIZED.getErrorMessage());
        }
        return (MosipUserDto)validateResp.getRight();
    }
}

