/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.auth.defaultadapter.constant.AuthAdapterErrorCode;
import io.mosip.kernel.auth.defaultadapter.exception.AuthManagerException;
import io.mosip.kernel.core.authmanager.exception.AuthNException;
import io.mosip.kernel.core.authmanager.exception.AuthZException;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
@Order(value=-2147483648)
public class AuthAdapterExceptionHandler {
    @Autowired
    private ObjectMapper objectMapper;

    @ExceptionHandler(value={AuthenticationException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> onAuthenticationException(HttpServletRequest httpServletRequest, AuthenticationException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), e.getMessage());
        errorResponse.getErrors().add(error);
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity<ResponseWrapper<ServiceError>>(errorResponse, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> onAccessDeniedException(HttpServletRequest httpServletRequest, AccessDeniedException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(AuthAdapterErrorCode.FORBIDDEN.getErrorCode(), AuthAdapterErrorCode.FORBIDDEN.getErrorMessage());
        errorResponse.getErrors().add(error);
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity<ResponseWrapper<ServiceError>>(errorResponse, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={AuthManagerException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> authManagerException(HttpServletRequest httpServletRequest, AuthManagerException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), e.getMessage());
        errorResponse.getErrors().add(error);
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity<ResponseWrapper<ServiceError>>(errorResponse, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={AuthNException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> authNException(HttpServletRequest httpServletRequest, AuthNException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        errorResponse.getErrors().addAll(e.getList());
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity<ResponseWrapper<ServiceError>>(errorResponse, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={AuthZException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> authZException(HttpServletRequest httpServletRequest, AuthZException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        errorResponse.getErrors().addAll(e.getList());
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity<ResponseWrapper<ServiceError>>(errorResponse, HttpStatus.FORBIDDEN);
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponsetime(LocalDateTime.now(ZoneId.of("UTC")));
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        this.objectMapper.registerModule(new JavaTimeModule());
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }
}

