/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import io.mosip.kernel.auth.defaultadapter.constant.AuthAdapterErrorCode;
import io.mosip.kernel.auth.defaultadapter.exception.AuthAdapterException;
import io.mosip.kernel.auth.defaultadapter.helper.TokenHelper;
import io.mosip.kernel.auth.defaultadapter.helper.TokenValidationHelper;
import io.mosip.kernel.auth.defaultadapter.model.TokenHolder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class SelfTokenExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfTokenExchangeFilterFunction.class);
    private String clientID;
    private String clientSecret;
    private String appID;
    private TokenHolder<String> cachedToken;
    private TokenHelper tokenHelper;
    private TokenValidationHelper tokenValidationHelper;
    private WebClient webClient;

    public SelfTokenExchangeFilterFunction(Environment environment2, WebClient webClient, TokenHolder<String> cachedToken, TokenHelper tokenHelper, TokenValidationHelper tokenValidationHelper, String applName) {
        this.clientID = environment2.getProperty("mosip.iam.adapter.clientid." + applName, environment2.getProperty("mosip.iam.adapter.clientid", ""));
        this.clientSecret = environment2.getProperty("mosip.iam.adapter.clientsecret." + applName, environment2.getProperty("mosip.iam.adapter.clientsecret", ""));
        this.appID = environment2.getProperty("mosip.iam.adapter.appid." + applName, environment2.getProperty("mosip.iam.adapter.appid", ""));
        this.cachedToken = cachedToken;
        this.webClient = webClient;
        this.tokenHelper = tokenHelper;
        this.tokenValidationHelper = tokenValidationHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        ClientRequest newReq;
        Mono<ClientResponse> clientResponse;
        ClientResponse response;
        if (this.cachedToken.getToken() == null) {
            String authToken = this.tokenHelper.getClientToken(this.clientID, this.clientSecret, this.appID, this.webClient);
            if (Objects.isNull(authToken)) {
                LOGGER.error("there is some issue with getting token with clienid and secret");
                throw new AuthAdapterException(AuthAdapterErrorCode.SELF_AUTH_TOKEN_NULL.getErrorCode(), AuthAdapterErrorCode.SELF_AUTH_TOKEN_NULL.getErrorMessage());
            }
            this.cachedToken.setToken(authToken);
        }
        if ((response = (clientResponse = next.exchange(newReq = ClientRequest.from(request).header("Cookie", "Authorization=" + this.cachedToken.getToken()).build())).block()).statusCode() != HttpStatus.UNAUTHORIZED) {
            return Mono.just(response);
        }
        SelfTokenExchangeFilterFunction selfTokenExchangeFilterFunction = this;
        synchronized (selfTokenExchangeFilterFunction) {
            if (!this.isTokenValid(this.cachedToken.getToken())) {
                String authToken = this.tokenHelper.getClientToken(this.clientID, this.clientSecret, this.appID, this.webClient);
                this.cachedToken.setToken(authToken);
            }
        }
        List cookies = request.headers().get("Cookie");
        if (cookies != null && !cookies.isEmpty()) {
            cookies = cookies.stream().filter(str -> !str.contains("Authorization=")).collect(Collectors.toList());
        }
        request.headers().replace("Cookie", cookies);
        request.headers().add("Cookie", "Authorization=" + this.cachedToken.getToken());
        return next.exchange(request);
    }

    private boolean isTokenValid(String authToken) {
        return Objects.nonNull(this.tokenValidationHelper.doOnlineTokenValidation(authToken, this.webClient));
    }
}

