/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import io.mosip.kernel.auth.defaultadapter.config.RestTemplateInterceptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplatePostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTemplatePostProcessor.class);

    @Bean
    public RestTemplateInterceptor restTemplateInterceptor() {
        return new RestTemplateInterceptor();
    }

    @Bean
    public SimpleClientHttpRequestFactory simpleClientHttpRequestFactory() {
        return new SimpleClientHttpRequestFactory();
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof RestTemplate && !beanName.equalsIgnoreCase("keycloakRestTemplate")) {
            LOGGER.info("Post processing REST_TEMPLATE bean : {} ", (Object)beanName);
            return this.getRestTemplate(bean2);
        }
        return bean2;
    }

    private RestTemplate getRestTemplate(Object bean2) {
        RestTemplate restTemplate = (RestTemplate)bean2;
        List<ClientHttpRequestInterceptor> list = restTemplate.getInterceptors();
        list.add(this.restTemplateInterceptor());
        restTemplate.setInterceptors(list);
        return restTemplate;
    }
}

