/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTemplateInterceptor.class);
    @Autowired
    private ClientHttpRequestFactory requestFactory;
    @Autowired(required=false)
    private LoadBalancerClient loadBalancerClient;

    @Override
    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        httpRequest = this.resolveServiceId(httpRequest);
        ClientHttpResponse response = clientHttpRequestExecution.execute(httpRequest, bytes);
        return response;
    }

    private HttpRequest resolveServiceId(HttpRequest request) {
        try {
            if (this.loadBalancerClient != null) {
                LOGGER.info("Injected load balancer : {} ", (Object)this.loadBalancerClient.toString());
                ServiceInstance instance = this.loadBalancerClient.choose(request.getURI().getHost());
                if (instance != null) {
                    ClientHttpRequest newRequest = this.requestFactory.createRequest(this.loadBalancerClient.reconstructURI(instance, request.getURI()), request.getMethod());
                    newRequest.getHeaders().addAll(request.getHeaders());
                    return newRequest;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to choose service instance : {}", (Object)ex.getMessage());
        }
        return request;
    }
}

