/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.ipc.http;

import io.micrometer.core.ipc.http.HttpSender;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;

public class OkHttpSender
implements HttpSender {
    private static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final MediaType MEDIA_TYPE_TEXT_PLAIN = MediaType.get((String)"text/plain; charset=utf-8");
    private final OkHttpClient client;

    public OkHttpSender(OkHttpClient client) {
        this.client = client;
    }

    public OkHttpSender() {
        this(new OkHttpClient());
    }

    @Override
    public HttpSender.Response send(HttpSender.Request request) throws Throwable {
        Request.Builder requestBuilder = new Request.Builder().url(request.getUrl());
        for (Map.Entry<String, String> requestHeader : request.getRequestHeaders().entrySet()) {
            requestBuilder.addHeader(requestHeader.getKey(), requestHeader.getValue());
        }
        byte[] entity = request.getEntity();
        String requestMethod = request.getMethod().toString();
        if (entity.length > 0) {
            String contentType2 = request.getRequestHeaders().get("Content-Type");
            MediaType mediaType = contentType2 != null ? MediaType.get((String)(contentType2 + "; charset=utf-8")) : MEDIA_TYPE_APPLICATION_JSON;
            RequestBody body2 = RequestBody.create((byte[])entity, (MediaType)mediaType);
            requestBuilder.method(requestMethod, body2);
        } else if (HttpMethod.requiresRequestBody((String)requestMethod)) {
            RequestBody body3 = RequestBody.create((byte[])entity, (MediaType)MEDIA_TYPE_TEXT_PLAIN);
            requestBuilder.method(requestMethod, body3);
        } else {
            requestBuilder.method(requestMethod, null);
        }
        Response response = this.client.newCall(requestBuilder.build()).execute();
        return new HttpSender.Response(response.code(), response.body() == null ? null : response.body().string());
    }
}

