/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import io.mosip.kernel.auth.defaultadapter.config.AuthEntryPoint;
import io.mosip.kernel.auth.defaultadapter.filter.AuthFilter;
import io.mosip.kernel.auth.defaultadapter.filter.CorsFilter;
import io.mosip.kernel.auth.defaultadapter.handler.AuthHandler;
import io.mosip.kernel.auth.defaultadapter.handler.AuthSuccessHandler;
import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Order(value=2)
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${mosip.security.csrf-enable:false}")
    private boolean isCSRFEnable;
    @Value(value="${mosip.security.cors-enable:false}")
    private boolean isCORSEnable;
    @Value(value="${mosip.security.origins:localhost:8080}")
    private String origins;
    @Autowired
    private AuthHandler authProvider;

    @Bean
    public AuthenticationManager authenticationManager() {
        return new ProviderManager(Collections.singletonList(this.authProvider));
    }

    @Bean
    public AbstractAuthenticationProcessingFilter authFilter() {
        AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher("*");
        AuthFilter filter = new AuthFilter((RequestMatcher)requestMatcher);
        filter.setAuthenticationManager(this.authenticationManager());
        filter.setAuthenticationSuccessHandler(new AuthSuccessHandler());
        return filter;
    }

    @Bean
    public FilterRegistrationBean<AbstractAuthenticationProcessingFilter> registration(AbstractAuthenticationProcessingFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registration.setEnabled(false);
        return registration;
    }

    protected void configure(HttpSecurity http) throws Exception {
        if (!this.isCSRFEnable) {
            http = (HttpSecurity)http.csrf().disable();
        }
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"*"})).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new AuthEntryPoint()).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.addFilterBefore((Filter)this.authFilter(), UsernamePasswordAuthenticationFilter.class);
        if (this.isCORSEnable) {
            http.addFilterBefore((Filter)new CorsFilter(this.origins), AuthFilter.class);
        }
        http.headers().cacheControl();
        http.headers().frameOptions().sameOrigin();
    }
}

