/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import io.mosip.kernel.auth.defaultadapter.config.RestTemplateInterceptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplatePostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTemplatePostProcessor.class);

    @Bean
    public RestTemplateInterceptor restTemplateInterceptor() {
        return new RestTemplateInterceptor();
    }

    @Bean
    public SimpleClientHttpRequestFactory simpleClientHttpRequestFactory() {
        return new SimpleClientHttpRequestFactory();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RestTemplate && !beanName.equalsIgnoreCase("keycloakRestTemplate")) {
            LOGGER.info("Post processing REST_TEMPLATE bean : {} ", (Object)beanName);
            return this.getRestTemplate(bean);
        }
        return bean;
    }

    private RestTemplate getRestTemplate(Object bean) {
        RestTemplate restTemplate = (RestTemplate)bean;
        List list = restTemplate.getInterceptors();
        list.add(this.restTemplateInterceptor());
        restTemplate.setInterceptors(list);
        return restTemplate;
    }
}

