/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import io.mosip.kernel.core.authmanager.authadapter.model.AuthUserDetails;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTemplateInterceptor.class);
    @Autowired
    private ClientHttpRequestFactory requestFactory;
    @Autowired(required=false)
    private LoadBalancerClient loadBalancerClient;

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        this.addHeadersToRequest(httpRequest, bytes);
        httpRequest = this.resolveServiceId(httpRequest);
        ClientHttpResponse response = clientHttpRequestExecution.execute(httpRequest, bytes);
        return response;
    }

    private void addHeadersToRequest(HttpRequest httpRequest, byte[] bytes) {
        HttpHeaders headers = httpRequest.getHeaders();
        AuthUserDetails authUserDetails = this.getAuthUserDetails();
        if (authUserDetails != null) {
            headers.set("Cookie", "Authorization=" + authUserDetails.getToken());
        }
    }

    private AuthUserDetails getAuthUserDetails() {
        AuthUserDetails authUserDetails = null;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof AuthUserDetails) {
            authUserDetails = (AuthUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        return authUserDetails;
    }

    private void getHeadersFromResponse(ClientHttpResponse clientHttpResponse) {
        HttpHeaders headers = clientHttpResponse.getHeaders();
        String responseToken = ((String)headers.get((Object)"Set-Cookie").get(0)).replaceAll("Authorization=", "");
        this.getAuthUserDetails().setToken(responseToken);
    }

    private HttpRequest resolveServiceId(HttpRequest request) {
        try {
            if (this.loadBalancerClient != null) {
                LOGGER.info("Injected load balancer : {} ", (Object)this.loadBalancerClient.toString());
                ServiceInstance instance = this.loadBalancerClient.choose(request.getURI().getHost());
                if (instance != null) {
                    ClientHttpRequest newRequest = this.requestFactory.createRequest(this.loadBalancerClient.reconstructURI(instance, request.getURI()), request.getMethod());
                    newRequest.getHeaders().addAll((MultiValueMap)request.getHeaders());
                    return newRequest;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to choose service instance : " + ex.getMessage());
            LOGGER.debug("Failed to choose service instance", (Throwable)ex);
        }
        return request;
    }
}

