/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.adapter.handler;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.mosip.kernel.auth.adapter.config.RestTemplateInterceptor;
import io.mosip.kernel.auth.adapter.constant.AuthAdapterErrorCode;
import io.mosip.kernel.auth.adapter.exception.AuthManagerException;
import io.mosip.kernel.auth.adapter.model.AuthToken;
import io.mosip.kernel.auth.adapter.model.AuthUserDetails;
import io.mosip.kernel.auth.adapter.model.MosipUserDto;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.www.NonceExpiredException;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class AuthHandler
extends AbstractUserDetailsAuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthHandler.class);
    @Value(value="${auth.server.validate.url}")
    private String validateUrl;
    @Value(value="${auth.server.admin.validate.url:http://localhost:8091/v1/authmanager/authorize/admin/validateToken}")
    private String adminValidateUrl;
    @Value(value="${auth.jwt.base:Mosip-Token}")
    private String authJwtBase;
    @Value(value="${auth.jwt.secret:authjwtsecret}")
    private String authJwtSecret;
    @Autowired
    private ObjectMapper objectMapper;

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken) throws AuthenticationException {
    }

    protected UserDetails retrieveUser(String userName, UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken) throws AuthenticationException {
        ResponseEntity<String> response = null;
        String token = null;
        AuthToken authToken = (AuthToken)usernamePasswordAuthenticationToken;
        token = authToken.getToken();
        MosipUserDto mosipUserDto = null;
        response = this.getKeycloakValidatedUserResponse(token);
        List validationErrorsList = ExceptionUtils.getServiceErrorList((String)((String)response.getBody()));
        if (!validationErrorsList.isEmpty()) {
            throw new AuthManagerException(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), validationErrorsList);
        }
        try {
            ResponseWrapper responseObject = (ResponseWrapper)this.objectMapper.readValue((String)response.getBody(), ResponseWrapper.class);
            mosipUserDto = (MosipUserDto)this.objectMapper.readValue(this.objectMapper.writeValueAsString(responseObject.getResponse()), MosipUserDto.class);
            LOGGER.info("user " + mosipUserDto.getUserId());
        }
        catch (Exception e) {
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), e);
        }
        List grantedAuthorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)mosipUserDto.getRole());
        AuthUserDetails authUserDetails = new AuthUserDetails(mosipUserDto, token);
        authUserDetails.setAuthorities(grantedAuthorities);
        return authUserDetails;
    }

    private Claims getClaims(String token) throws Exception {
        String token_base = this.authJwtBase;
        String secret = this.authJwtSecret;
        Claims claims = null;
        if (token == null || !token.startsWith(token_base)) {
            throw new NonceExpiredException("Invalid Token");
        }
        claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token.substring(token_base.length())).getBody();
        return claims;
    }

    private MosipUserDto buildDto(Claims claims) {
        MosipUserDto mosipUserDto = new MosipUserDto();
        mosipUserDto.setUserId(claims.getSubject());
        mosipUserDto.setName((String)claims.get((Object)"name"));
        mosipUserDto.setRole((String)claims.get((Object)"role"));
        mosipUserDto.setMail((String)claims.get((Object)"mail"));
        mosipUserDto.setMobile((String)claims.get((Object)"mobile"));
        mosipUserDto.setRId((String)claims.get((Object)"rId"));
        return mosipUserDto;
    }

    private ResponseEntity<String> getValidatedUserResponse(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cookie", "Authorization=" + token);
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        try {
            return this.getRestTemplate().exchange(this.validateUrl, HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | RestClientException e) {
            throw new AuthManagerException(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), e.getMessage(), e);
        }
    }

    private ResponseEntity<String> getKeycloakValidatedUserResponse(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cookie", "Authorization=" + token);
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        try {
            LOGGER.info("url " + this.adminValidateUrl);
            return this.getRestTemplate().exchange(this.adminValidateUrl, HttpMethod.GET, entity, String.class, new Object[0]);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | RestClientException e) {
            throw new AuthManagerException(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), e.getMessage(), e);
        }
    }

    public RestTemplate getRestTemplate() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setInterceptors(Collections.singletonList(new RestTemplateInterceptor()));
        return restTemplate;
    }

    public void addCorsFilter(HttpServer httpServer, Vertx vertx) {
        Router router = Router.router((Vertx)vertx);
        router.route().handler(routingContext -> {
            HttpServerResponse httpServerResponse = routingContext.response();
            httpServerResponse.putHeader("Cache-Control", "no-store, no-cache,max-age=0, must-revalidate").putHeader("Pragma", "no-cache").putHeader("X-Content-Type-Options", "nosniff").putHeader("Strict-Transport-Security", "max-age=15768000; includeSubDomains").putHeader("X-Download-Options", "noopen").putHeader("X-XSS-Protection", "1; mode=block").putHeader("X-FRAME-OPTIONS", "DENY");
            routingContext.next();
        });
        httpServer.requestHandler((Handler)router);
    }

    public void addAuthFilter(Router router, String path, io.vertx.core.http.HttpMethod httpMethod, String commaSepratedRoles) {
        Objects.requireNonNull(httpMethod, "Http Method Cannot Be Null");
        if (EmptyCheckUtils.isNullEmpty((String)commaSepratedRoles)) {
            throw new NullPointerException("Roles Cannot Be Empty or Null");
        }
        String[] roles = commaSepratedRoles.split(",");
        Route filterRoute = router.route(httpMethod, path);
        filterRoute.handler(routingContext -> {
            try {
                String token = this.validateToken((RoutingContext)routingContext, roles);
                if (token.isEmpty()) {
                    return;
                }
                HttpServerResponse httpServerResponse = routingContext.response();
                httpServerResponse.putHeader("Set-Cookie", token);
                routingContext.next();
            }
            catch (Exception e) {
                throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), e);
            }
        });
    }

    private String validateToken(RoutingContext routingContext, String[] roles) throws RestClientException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JsonParseException, JsonMappingException, JsonProcessingException, IOException {
        boolean isAuthorized = false;
        HttpServerRequest httpRequest = routingContext.request();
        String token = null;
        String cookies = httpRequest.getHeader("Cookie");
        if (cookies != null && !cookies.isEmpty() && cookies.contains("Authorization=")) {
            token = cookies.replace("Authorization=", "").trim();
        }
        if (token == null || token.isEmpty()) {
            ArrayList<ServiceError> errors = new ArrayList<ServiceError>();
            ServiceError error = new ServiceError(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), AuthAdapterErrorCode.UNAUTHORIZED.getErrorMessage());
            LOGGER.error(error.getMessage());
            errors.add(error);
            this.sendErrors(routingContext, errors, 401);
            return "";
        }
        ResponseEntity<String> response = this.getKeycloakValidatedUserResponse(token = token.split(";")[0]);
        if (response == null) {
            ArrayList<ServiceError> errors = new ArrayList<ServiceError>();
            ServiceError error = new ServiceError(AuthAdapterErrorCode.CONNECT_EXCEPTION.getErrorCode(), AuthAdapterErrorCode.CONNECT_EXCEPTION.getErrorMessage());
            LOGGER.error(error.getMessage());
            errors.add(error);
            this.sendErrors(routingContext, errors, 500);
            return "";
        }
        List validationErrorsList = ExceptionUtils.getServiceErrorList((String)((String)response.getBody()));
        if (!validationErrorsList.isEmpty()) {
            LOGGER.error("count " + validationErrorsList.size());
            this.sendErrors(routingContext, validationErrorsList, 401);
            return "";
        }
        ResponseWrapper responseObject = null;
        MosipUserDto mosipUserDto = null;
        responseObject = (ResponseWrapper)this.objectMapper.readValue((String)response.getBody(), ResponseWrapper.class);
        mosipUserDto = (MosipUserDto)this.objectMapper.readValue(this.objectMapper.writeValueAsString(responseObject.getResponse()), MosipUserDto.class);
        AuthUserDetails authUserDetails = new AuthUserDetails(mosipUserDto, token);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)authUserDetails, (Object)authUserDetails.getPassword(), null);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        String[] authorities = mosipUserDto.getRole().split(",");
        block0: for (String role : roles) {
            for (String authority : authorities) {
                if (!role.equals(authority)) continue;
                isAuthorized = true;
                continue block0;
            }
        }
        if (!isAuthorized) {
            ArrayList<ServiceError> errors = new ArrayList<ServiceError>();
            ServiceError error = new ServiceError(AuthAdapterErrorCode.FORBIDDEN.getErrorCode(), AuthAdapterErrorCode.FORBIDDEN.getErrorMessage());
            LOGGER.error(error.getMessage());
            errors.add(error);
            this.sendErrors(routingContext, errors, 403);
            return "";
        }
        return ((String)response.getHeaders().get((Object)"Set-Cookie").get(0)).replaceAll("Authorization=", "");
    }

    private void sendErrors(RoutingContext routingContext, List<ServiceError> errors, int statusCode) {
        ResponseWrapper errorResponse = new ResponseWrapper();
        errorResponse.getErrors().addAll(errors);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        if (routingContext.getBodyAsJson() != null) {
            try {
                JsonNode reqNode = this.objectMapper.readTree(routingContext.getBodyAsJson().toString());
                errorResponse.setId(reqNode.path("id").asText());
                errorResponse.setVersion(reqNode.path("version").asText());
            }
            catch (IOException exception) {
                LOGGER.error(exception.getMessage());
            }
        }
        try {
            routingContext.response().putHeader("content-type", "application/json").setStatusCode(statusCode).end(this.objectMapper.writeValueAsString((Object)errorResponse));
        }
        catch (JsonProcessingException exception) {
            LOGGER.error(exception.getMessage());
        }
    }
}

