/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.adapter.config;

import io.mosip.kernel.auth.adapter.config.AuthEntryPoint;
import io.mosip.kernel.auth.adapter.filter.AuthFilter;
import io.mosip.kernel.auth.adapter.filter.CorsFilter;
import io.mosip.kernel.auth.adapter.handler.AuthHandler;
import io.mosip.kernel.auth.adapter.handler.AuthSuccessHandler;
import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Order(value=2)
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AuthHandler authProvider;

    @Bean
    public AuthenticationManager authenticationManager() {
        return new ProviderManager(Collections.singletonList(this.authProvider));
    }

    @Bean
    public AuthFilter authFilter() {
        AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher("*");
        AuthFilter filter = new AuthFilter((RequestMatcher)requestMatcher);
        filter.setAuthenticationManager(this.authenticationManager());
        filter.setAuthenticationSuccessHandler(new AuthSuccessHandler());
        return filter;
    }

    @Bean
    public FilterRegistrationBean<AuthFilter> registration(AuthFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registration.setEnabled(false);
        return registration;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"*"})).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new AuthEntryPoint()).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.addFilterBefore((Filter)this.authFilter(), UsernamePasswordAuthenticationFilter.class);
        http.addFilterBefore((Filter)new CorsFilter(), AuthFilter.class);
        http.headers().cacheControl();
        http.headers().frameOptions().sameOrigin();
    }
}

