/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.adapter.config;

import io.mosip.kernel.auth.adapter.model.AuthUserDetails;
import java.io.IOException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        this.addHeadersToRequest(httpRequest, bytes);
        ClientHttpResponse response = clientHttpRequestExecution.execute(httpRequest, bytes);
        return response;
    }

    private void addHeadersToRequest(HttpRequest httpRequest, byte[] bytes) {
        HttpHeaders headers = httpRequest.getHeaders();
        AuthUserDetails authUserDetails = this.getAuthUserDetails();
        if (authUserDetails != null) {
            headers.set("Cookie", "Authorization=" + authUserDetails.getToken());
        }
    }

    private AuthUserDetails getAuthUserDetails() {
        AuthUserDetails authUserDetails = null;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof AuthUserDetails) {
            authUserDetails = (AuthUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        return authUserDetails;
    }

    private void getHeadersFromResponse(ClientHttpResponse clientHttpResponse) {
        HttpHeaders headers = clientHttpResponse.getHeaders();
        String responseToken = ((String)headers.get((Object)"Set-Cookie").get(0)).replaceAll("Authorization=", "");
        this.getAuthUserDetails().setToken(responseToken);
    }
}

