/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.adapter.config;

import io.mosip.kernel.auth.adapter.config.RestTemplateInterceptor;
import io.mosip.kernel.auth.adapter.model.AuthUserDetails;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class BeanConfig {
    @Value(value="${mosip.kernel.auth.adapter.ssl-bypass:true}")
    private boolean sslBypass;

    @Bean
    public RestTemplate restTemplate() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        RestTemplate restTemplate = null;
        if (this.sslBypass) {
            TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
            SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
            requestFactory.setHttpClient((HttpClient)httpClient);
            restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        } else {
            restTemplate = new RestTemplate();
        }
        restTemplate.setInterceptors(Collections.singletonList(new RestTemplateInterceptor()));
        return restTemplate;
    }

    @Bean
    public WebClient webClient() {
        return WebClient.builder().filter((req, next) -> {
            ClientRequest filtered = null;
            if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof AuthUserDetails) {
                AuthUserDetails userDetail = (AuthUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                filtered = ClientRequest.from((ClientRequest)req).header("Cookie", new String[]{"Authorization=" + userDetail.getToken()}).build();
            }
            return next.exchange(filtered);
        }).build();
    }
}

