/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auditmanager.controller;

import io.mosip.kernel.auditmanager.dto.AuditResponseDto;
import io.mosip.kernel.auditmanager.request.AuditRequestDto;
import io.mosip.kernel.auditmanager.service.AuditManagerService;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class AuditManagerController {
    @Value(value="${mosip.kernel.auditmanager.add-audit.api-id:mosip.kernel.auditmanager.addAudit}")
    private String apiId;
    @Value(value="${mosip.kernel.auditmanager.add-audit.api-version:1.0}")
    private String apiVersion;
    @Autowired
    AuditManagerService service;

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION','PRE_REGISTRATION_ADMIN','RESIDENT','ZONAL_ADMIN','GLOBAL_ADMIN')")
    @ResponseFilter
    @PostMapping(value={"/audits"}, produces={"application/json"})
    public ResponseWrapper<AuditResponseDto> addAudit(@RequestBody @Valid RequestWrapper<AuditRequestDto> requestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.service.addAudit((AuditRequestDto)requestDto.getRequest()));
        response.setId(this.apiId);
        response.setVersion(this.apiVersion);
        response.setErrors(null);
        return response;
    }
}

