/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auditmanager.config;

import io.mosip.kernel.auditmanager.config.ReqResFilter;
import io.mosip.kernel.auditmanager.exception.AuditAsyncExceptionHandler;
import java.util.concurrent.Executor;
import javax.servlet.Filter;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class AsyncConfig
implements AsyncConfigurer {
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.initialize();
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new AuditAsyncExceptionHandler();
    }

    @Bean
    public FilterRegistrationBean<Filter> registerReqResFilter() {
        FilterRegistrationBean corsBean = new FilterRegistrationBean();
        corsBean.setFilter(this.getReqResFilter());
        corsBean.setOrder(1);
        return corsBean;
    }

    @Bean
    public Filter getReqResFilter() {
        return new ReqResFilter();
    }
}

