/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auditmanager.exception;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.auditmanager.config.AuditManagerLogger;
import java.lang.reflect.Method;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;

public class AuditAsyncExceptionHandler
implements AsyncUncaughtExceptionHandler {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public void handleUncaughtException(Throwable throwable, Method method, Object ... obj) {
        AuditManagerLogger.consoleLoggerError((String)"", (String)"", (String)"", (String)("Exception message - " + throwable.getMessage()));
        for (Object param : obj) {
            try {
                AuditManagerLogger.fileLoggerError((String)"", (String)"", (String)"", (String)MAPPER.writeValueAsString(param));
                AuditManagerLogger.consoleLoggerError((String)"", (String)"", (String)"", (String)("Method name - " + method.getName() + "\n\n" + MAPPER.writeValueAsString(param)));
            }
            catch (JsonProcessingException e) {
                AuditManagerLogger.consoleLoggerError((String)"", (String)"", (String)"", (String)e.getMessage());
            }
        }
    }
}

