/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.commons.packet.cache.provider.hazelcast.config;

import com.hazelcast.core.HazelcastInstance;
import java.lang.reflect.Method;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
@ConditionalOnProperty(value={"packetmanager.hazelcast.disable.health.check"}, matchIfMissing=true)
public class HazelcastHealthIndicator
extends AbstractHealthIndicator {
    private final HazelcastInstance hazelcast;

    public HazelcastHealthIndicator(HazelcastInstance hazelcast) {
        super("Hazelcast health check failed");
        this.hazelcast = hazelcast;
    }

    protected void doHealthCheck(Health.Builder builder) {
        this.hazelcast.executeTransaction(context -> {
            builder.up().withDetail("name", (Object)this.hazelcast.getName()).withDetail("uuid", (Object)this.extractUuid()).withDetail("members", (Object)this.hazelcast.getCluster().getMembers().size());
            return null;
        });
    }

    private String extractUuid() {
        try {
            return this.hazelcast.getLocalEndpoint().getUuid();
        }
        catch (NoSuchMethodError ex) {
            Method endpointAccessor = ReflectionUtils.findMethod(HazelcastInstance.class, (String)"getLocalEndpoint");
            Object endpoint = ReflectionUtils.invokeMethod((Method)endpointAccessor, (Object)this.hazelcast);
            Method uuidAccessor = ReflectionUtils.findMethod(endpoint.getClass(), (String)"getUuid");
            return (String)ReflectionUtils.invokeMethod((Method)uuidAccessor, (Object)endpoint);
        }
    }
}

