/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TransactionalQueueOfferCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalQueuePeekCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalQueuePollCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalQueueSizeCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalQueueTakeCodec;
import com.hazelcast.client.proxy.txn.ClientTxnProxy;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.TimeUnit;

public class ClientTxnQueueProxy<E>
extends ClientTxnProxy
implements TransactionalQueue<E> {
    public ClientTxnQueueProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    @Override
    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Data data = this.toData(e);
        ClientMessage request = TransactionalQueueOfferCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), data, unit.toMillis(timeout));
        ClientMessage response = this.invoke(request);
        return TransactionalQueueOfferCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public E take() throws InterruptedException {
        ClientMessage request = TransactionalQueueTakeCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return (E)this.toObject(TransactionalQueueTakeCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public E poll() {
        try {
            return this.poll(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = TransactionalQueuePollCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), unit.toMillis(timeout));
        ClientMessage response = this.invoke(request);
        return (E)this.toObject(TransactionalQueuePollCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public E peek() {
        try {
            return this.peek(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public E peek(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = TransactionalQueuePeekCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), unit.toMillis(timeout));
        ClientMessage response = this.invoke(request);
        return (E)this.toObject(TransactionalQueuePeekCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public int size() {
        ClientMessage request = TransactionalQueueSizeCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return TransactionalQueueSizeCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    void onDestroy() {
    }
}

