/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import org.springframework.context.annotation.Conditional;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Conditional annotation that matches when any properties exist under the specified prefix.
 * This is useful for conditionally creating beans only when configuration properties
 * are present under a specific prefix.
 * 
 * <p>Example usage:
 * <pre>
 * &#64;Bean
 * &#64;ConditionalOnPropertyPrefix(prefix = "myapp.security")
 * public SecuritySource securitySource() {
 *     // This bean will only be created if properties like myapp.security.* exist
 * }
 * </pre>
 */
@Target({ ElementType.TYPE, ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Conditional(OnPropertyPrefixCondition.class)
public @interface ConditionalOnPropertyPrefix {

    /**
     * The property prefix to check for. Properties starting with this prefix
     * (followed by a dot) will be considered when determining if the condition matches.
     * 
     * @return the property prefix
     */
    String prefix();
}