/*
 * Decompiled with CFR 0.152.
 */
package io.moov.sdk;

import io.moov.sdk.utils.RetryConfig;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="sdk")
public class SDKAutoConfigProperties {
    private String serverUrl;
    private RetryConfig retryConfig = new RetryConfig();
    private HttpClient httpClient = new HttpClient();
    private int serverIdx = 0;
    private Globals globals = new Globals();
    private Security security = new Security();

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public RetryConfig getRetryConfig() {
        return this.retryConfig;
    }

    public void setRetryConfig(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public int getServerIdx() {
        return this.serverIdx;
    }

    public void setServerIdx(int serverIdx) {
        this.serverIdx = serverIdx;
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public void setGlobals(Globals globals) {
        this.globals = globals;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public static class Security {
        private String username;
        private String password;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class Globals {
        private String xMoovVersion;

        public String getXMoovVersion() {
            return this.xMoovVersion;
        }

        public void setXMoovVersion(String xMoovVersion) {
            this.xMoovVersion = xMoovVersion;
        }
    }

    public static class HttpClient {
        private boolean enableDebugLogging = false;
        private Collection<String> redactedHeaders = Set.of("Authorization", "X-API-KEY");

        public boolean isEnableDebugLogging() {
            return this.enableDebugLogging;
        }

        public void setEnableDebugLogging(boolean enableDebugLogging) {
            this.enableDebugLogging = enableDebugLogging;
        }

        public Collection<String> getRedactedHeaders() {
            return this.redactedHeaders;
        }

        public void setRedactedHeaders(Collection<String> redactedHeaders) {
            this.redactedHeaders = redactedHeaders;
        }
    }

    public static class RetryConfig {
        private RetryConfig.Strategy strategy;
        private Backoff backoff = new Backoff();

        public RetryConfig.Strategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(RetryConfig.Strategy strategy) {
            this.strategy = strategy;
        }

        public Backoff getBackoff() {
            return this.backoff;
        }

        public void setBackoff(Backoff backoff) {
            this.backoff = backoff;
        }

        public static class Backoff {
            private Duration initialInterval = Duration.ofMillis(500L);
            private Duration maxInterval = Duration.ofSeconds(60L);
            private Duration maxElapsedTime = Duration.ofHours(1L);
            private double baseFactor = 1.5;
            private double jitterFactor = 0.5;
            private boolean retryConnectError = false;
            private boolean retryReadTimeoutError = false;

            public Duration getInitialInterval() {
                return this.initialInterval;
            }

            public void setInitialInterval(Duration initialInterval) {
                this.initialInterval = initialInterval;
            }

            public Duration getMaxInterval() {
                return this.maxInterval;
            }

            public void setMaxInterval(Duration maxInterval) {
                this.maxInterval = maxInterval;
            }

            public Duration getMaxElapsedTime() {
                return this.maxElapsedTime;
            }

            public void setMaxElapsedTime(Duration maxElapsedTime) {
                this.maxElapsedTime = maxElapsedTime;
            }

            public double getBaseFactor() {
                return this.baseFactor;
            }

            public void setBaseFactor(double baseFactor) {
                this.baseFactor = baseFactor;
            }

            public double getJitterFactor() {
                return this.jitterFactor;
            }

            public void setJitterFactor(double jitterFactor) {
                this.jitterFactor = jitterFactor;
            }

            public boolean isRetryConnectError() {
                return this.retryConnectError;
            }

            public void setRetryConnectError(boolean retryConnectError) {
                this.retryConnectError = retryConnectError;
            }

            public boolean isRetryReadTimeoutError() {
                return this.retryReadTimeoutError;
            }

            public void setRetryReadTimeoutError(boolean retryReadTimeoutError) {
                this.retryReadTimeoutError = retryReadTimeoutError;
            }
        }
    }
}

