/*
 * Decompiled with CFR 0.152.
 */
package io.moov.sdk;

import io.moov.sdk.AccountTerminalApplications;
import io.moov.sdk.Accounts;
import io.moov.sdk.Adjustments;
import io.moov.sdk.ApplePay;
import io.moov.sdk.Authentication;
import io.moov.sdk.Avatars;
import io.moov.sdk.BankAccounts;
import io.moov.sdk.Branding;
import io.moov.sdk.Capabilities;
import io.moov.sdk.CardIssuing;
import io.moov.sdk.Cards;
import io.moov.sdk.ConditionalOnPropertyPrefix;
import io.moov.sdk.Disputes;
import io.moov.sdk.EndToEndEncryption;
import io.moov.sdk.EnrichedAddress;
import io.moov.sdk.EnrichedProfile;
import io.moov.sdk.FeePlans;
import io.moov.sdk.Files;
import io.moov.sdk.Images;
import io.moov.sdk.Industries;
import io.moov.sdk.Institutions;
import io.moov.sdk.IssuingTransactions;
import io.moov.sdk.Moov;
import io.moov.sdk.Onboarding;
import io.moov.sdk.PaymentLinks;
import io.moov.sdk.PaymentMethods;
import io.moov.sdk.Ping;
import io.moov.sdk.Products;
import io.moov.sdk.Receipts;
import io.moov.sdk.Representatives;
import io.moov.sdk.SDKAutoConfigProperties;
import io.moov.sdk.SDKConfiguration;
import io.moov.sdk.Scheduling;
import io.moov.sdk.SecuritySource;
import io.moov.sdk.Statements;
import io.moov.sdk.Support;
import io.moov.sdk.Sweeps;
import io.moov.sdk.TerminalApplications;
import io.moov.sdk.Transfers;
import io.moov.sdk.Underwriting;
import io.moov.sdk.WalletTransactions;
import io.moov.sdk.Wallets;
import io.moov.sdk.models.components.Security;
import io.moov.sdk.utils.BackoffStrategy;
import io.moov.sdk.utils.Globals;
import io.moov.sdk.utils.HTTPClient;
import io.moov.sdk.utils.HasSecurity;
import io.moov.sdk.utils.Hooks;
import io.moov.sdk.utils.RetryConfig;
import io.moov.sdk.utils.SpeakeasyHTTPClient;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={Moov.class})
@EnableConfigurationProperties(value={SDKAutoConfigProperties.class})
public class SDKAutoConfig {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sdk.retry-config", name={"strategy"})
    public RetryConfig retryConfig(SDKAutoConfigProperties properties) {
        SDKAutoConfigProperties.RetryConfig retryProps = properties.getRetryConfig();
        if (RetryConfig.Strategy.BACKOFF.equals((Object)retryProps.getStrategy())) {
            SDKAutoConfigProperties.RetryConfig.Backoff backoff = retryProps.getBackoff();
            return RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(backoff.getInitialInterval().toMillis(), TimeUnit.MILLISECONDS).maxInterval(backoff.getMaxInterval().toMillis(), TimeUnit.MILLISECONDS).maxElapsedTime(backoff.getMaxElapsedTime().toMillis(), TimeUnit.MILLISECONDS).baseFactor(backoff.getBaseFactor()).jitterFactor(backoff.getJitterFactor()).retryConnectError(backoff.isRetryConnectError()).retryReadTimeoutError(backoff.isRetryReadTimeoutError()).build()).build();
        }
        return RetryConfig.builder().build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Consumer<String> httpLogger() {
        return System.out::println;
    }

    @Bean
    @ConditionalOnMissingBean
    public HTTPClient httpClient(SDKAutoConfigProperties properties, Consumer<String> httpLogger) {
        SDKAutoConfigProperties.HttpClient httpClientProps = properties.getHttpClient();
        SpeakeasyHTTPClient.setLogger(httpLogger);
        if (httpClientProps != null) {
            SpeakeasyHTTPClient.setDebugLogging((boolean)httpClientProps.isEnableDebugLogging());
            if (httpClientProps.getRedactedHeaders() != null && !httpClientProps.getRedactedHeaders().isEmpty()) {
                SpeakeasyHTTPClient.setRedactedHeaders(httpClientProps.getRedactedHeaders());
            }
        }
        return new SpeakeasyHTTPClient();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnPropertyPrefix(prefix="sdk.security")
    public SecuritySource securitySource(SDKAutoConfigProperties properties) {
        SDKAutoConfigProperties.Security securityProps = properties.getSecurity();
        Security.Builder securityBuilder = Security.builder();
        boolean hasAnySecurityConfiguration = false;
        if (securityProps.getUsername() != null) {
            securityBuilder.username(securityProps.getUsername());
            hasAnySecurityConfiguration = true;
        }
        if (securityProps.getPassword() != null) {
            securityBuilder.password(securityProps.getPassword());
            hasAnySecurityConfiguration = true;
        }
        if (!hasAnySecurityConfiguration) {
            throw new IllegalStateException("Security configuration is present but no security options are configured. Please configure at least one security option in your application properties.");
        }
        return SecuritySource.of((HasSecurity)securityBuilder.build());
    }

    @Bean
    @ConditionalOnMissingBean
    public SDKConfiguration sdkConfiguration(SDKAutoConfigProperties properties, HTTPClient httpClient, Hooks hooks, SecuritySource securitySource, Globals globals, Optional<RetryConfig> retryConfig) {
        SDKConfiguration sdkConfiguration = new SDKConfiguration();
        sdkConfiguration.setClient(httpClient);
        sdkConfiguration.setHooks(hooks);
        sdkConfiguration.setSecuritySource(securitySource);
        if (properties.getServerUrl() != null) {
            sdkConfiguration.setServerUrl(properties.getServerUrl());
        }
        sdkConfiguration.setServerIdx(properties.getServerIdx());
        sdkConfiguration.setGlobals(globals);
        sdkConfiguration.setRetryConfig(retryConfig);
        return sdkConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean
    public Moov moov(SDKConfiguration sdkConfiguration) {
        return new Moov(sdkConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean
    public Globals globals(SDKAutoConfigProperties properties) {
        Globals globals = new Globals();
        SDKAutoConfigProperties.Globals globalProps = properties.getGlobals();
        if (globalProps.getXMoovVersion() != null) {
            globals.putParam("header", "xMoovVersion", (Object)globalProps.getXMoovVersion());
        }
        return globals;
    }

    @Bean
    @ConditionalOnMissingBean
    public Hooks hooks() {
        return new Hooks();
    }

    @Bean
    @ConditionalOnMissingBean
    public Accounts accounts(Moov moov) {
        return moov.accounts();
    }

    @Bean
    @ConditionalOnMissingBean
    public Adjustments adjustments(Moov moov) {
        return moov.adjustments();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplePay applePay(Moov moov) {
        return moov.applePay();
    }

    @Bean
    @ConditionalOnMissingBean
    public BankAccounts bankAccounts(Moov moov) {
        return moov.bankAccounts();
    }

    @Bean
    @ConditionalOnMissingBean
    public Branding branding(Moov moov) {
        return moov.branding();
    }

    @Bean
    @ConditionalOnMissingBean
    public Capabilities capabilities(Moov moov) {
        return moov.capabilities();
    }

    @Bean
    @ConditionalOnMissingBean
    public Cards cards(Moov moov) {
        return moov.cards();
    }

    @Bean
    @ConditionalOnMissingBean
    public Disputes disputes(Moov moov) {
        return moov.disputes();
    }

    @Bean
    @ConditionalOnMissingBean
    public FeePlans feePlans(Moov moov) {
        return moov.feePlans();
    }

    @Bean
    @ConditionalOnMissingBean
    public Files files(Moov moov) {
        return moov.files();
    }

    @Bean
    @ConditionalOnMissingBean
    public Images images(Moov moov) {
        return moov.images();
    }

    @Bean
    @ConditionalOnMissingBean
    public PaymentLinks paymentLinks(Moov moov) {
        return moov.paymentLinks();
    }

    @Bean
    @ConditionalOnMissingBean
    public PaymentMethods paymentMethods(Moov moov) {
        return moov.paymentMethods();
    }

    @Bean
    @ConditionalOnMissingBean
    public Products products(Moov moov) {
        return moov.products();
    }

    @Bean
    @ConditionalOnMissingBean
    public Representatives representatives(Moov moov) {
        return moov.representatives();
    }

    @Bean
    @ConditionalOnMissingBean
    public Scheduling scheduling(Moov moov) {
        return moov.scheduling();
    }

    @Bean
    @ConditionalOnMissingBean
    public Statements statements(Moov moov) {
        return moov.statements();
    }

    @Bean
    @ConditionalOnMissingBean
    public Sweeps sweeps(Moov moov) {
        return moov.sweeps();
    }

    @Bean
    @ConditionalOnMissingBean
    public AccountTerminalApplications accountTerminalApplications(Moov moov) {
        return moov.accountTerminalApplications();
    }

    @Bean
    @ConditionalOnMissingBean
    public Support support(Moov moov) {
        return moov.support();
    }

    @Bean
    @ConditionalOnMissingBean
    public Transfers transfers(Moov moov) {
        return moov.transfers();
    }

    @Bean
    @ConditionalOnMissingBean
    public Underwriting underwriting(Moov moov) {
        return moov.underwriting();
    }

    @Bean
    @ConditionalOnMissingBean
    public Wallets wallets(Moov moov) {
        return moov.wallets();
    }

    @Bean
    @ConditionalOnMissingBean
    public WalletTransactions walletTransactions(Moov moov) {
        return moov.walletTransactions();
    }

    @Bean
    @ConditionalOnMissingBean
    public Avatars avatars(Moov moov) {
        return moov.avatars();
    }

    @Bean
    @ConditionalOnMissingBean
    public EndToEndEncryption endToEndEncryption(Moov moov) {
        return moov.endToEndEncryption();
    }

    @Bean
    @ConditionalOnMissingBean
    public EnrichedAddress enrichedAddress(Moov moov) {
        return moov.enrichedAddress();
    }

    @Bean
    @ConditionalOnMissingBean
    public EnrichedProfile enrichedProfile(Moov moov) {
        return moov.enrichedProfile();
    }

    @Bean
    @ConditionalOnMissingBean
    public Industries industries(Moov moov) {
        return moov.industries();
    }

    @Bean
    @ConditionalOnMissingBean
    public Institutions institutions(Moov moov) {
        return moov.institutions();
    }

    @Bean
    @ConditionalOnMissingBean
    public IssuingTransactions issuingTransactions(Moov moov) {
        return moov.issuingTransactions();
    }

    @Bean
    @ConditionalOnMissingBean
    public CardIssuing cardIssuing(Moov moov) {
        return moov.cardIssuing();
    }

    @Bean
    @ConditionalOnMissingBean
    public Authentication authentication(Moov moov) {
        return moov.authentication();
    }

    @Bean
    @ConditionalOnMissingBean
    public Onboarding onboarding(Moov moov) {
        return moov.onboarding();
    }

    @Bean
    @ConditionalOnMissingBean
    public Ping ping(Moov moov) {
        return moov.ping();
    }

    @Bean
    @ConditionalOnMissingBean
    public Receipts receipts(Moov moov) {
        return moov.receipts();
    }

    @Bean
    @ConditionalOnMissingBean
    public TerminalApplications terminalApplications(Moov moov) {
        return moov.terminalApplications();
    }
}

