/*
 * Decompiled with CFR 0.152.
 */
package io.moov.sdk;

import io.moov.sdk.ConditionalOnPropertyPrefix;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnPropertyPrefixCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnPropertyPrefix.class.getName());
        if (attributes == null) {
            return ConditionOutcome.noMatch((String)"@ConditionalOnPropertyPrefix annotation not found");
        }
        String prefix = (String)attributes.get("prefix");
        if (prefix == null || prefix.isEmpty()) {
            return ConditionOutcome.noMatch((String)"Property prefix is empty");
        }
        Environment environment = context.getEnvironment();
        boolean hasPropertiesUnderPrefix = this.hasPropertiesWithPrefix(environment, prefix);
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnPropertyPrefix.class, (Object[])new Object[]{prefix});
        if (hasPropertiesUnderPrefix) {
            return ConditionOutcome.match((ConditionMessage)message.found("properties").items(new Object[]{prefix + ".*"}));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("properties").items(new Object[]{prefix + ".*"}));
    }

    private boolean hasPropertiesWithPrefix(Environment environment, String prefix) {
        try {
            Binder binder = Binder.get((Environment)environment);
            return binder.bind(prefix, Map.class).isBound();
        }
        catch (Exception e) {
            return false;
        }
    }
}

