/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.env.Environment;

import java.util.Map;

/**
 * Custom condition that checks if any properties exist under a given prefix.
 * This is used to conditionally create beans only when configuration properties
 * are present under a specific prefix.
 */
public class OnPropertyPrefixCondition extends SpringBootCondition {

    /**
     * Default constructor for OnPropertyPrefixCondition.
     */
    public OnPropertyPrefixCondition() {
        // Default constructor
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnPropertyPrefix.class.getName());
        if (attributes == null) {
            return ConditionOutcome.noMatch("@ConditionalOnPropertyPrefix annotation not found");
        }

        String prefix = (String) attributes.get("prefix");
        if (prefix == null || prefix.isEmpty()) {
            return ConditionOutcome.noMatch("Property prefix is empty");
        }

        Environment environment = context.getEnvironment();
        
        // Check if any properties exist under the given prefix
        boolean hasPropertiesUnderPrefix = hasPropertiesWithPrefix(environment, prefix);
        
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnPropertyPrefix.class, prefix);
        
        if (hasPropertiesUnderPrefix) {
            return ConditionOutcome.match(message.found("properties").items(prefix + ".*"));
        } else {
            return ConditionOutcome.noMatch(message.didNotFind("properties").items(prefix + ".*"));
        }
    }

    private boolean hasPropertiesWithPrefix(Environment environment, String prefix) {
        try {
            // Use Spring Boot's Binder to check if any properties exist under the prefix
            Binder binder = Binder.get(environment);
            
            // Try to bind to a Map to see if any properties exist under the prefix
            return binder.bind(prefix, Map.class).isBound();
        } catch (Exception e) {
            // If we can't determine, assume no properties exist
            return false;
        }
    }
}