/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;
import java.lang.String;
import java.util.Collection;
import java.util.Set;


/**
 * Spring Boot Configuration Properties for sdk SDK
 */
@ConfigurationProperties(prefix = "sdk")
public class SDKAutoConfigProperties {

    /**
     * Constructor.
     */
    public SDKAutoConfigProperties() {
    }

    /**
     * The base URL for the API server. If not specified, the SDK will use the default server URL.
     */
    private String serverUrl;
    
    /**
     * Configuration for retry behavior when API calls fail due to transient errors.
     */
    private RetryConfig retryConfig = new RetryConfig();
    
    /**
     * HTTP client configuration for API requests.
     */
    private HttpClient httpClient = new HttpClient();
    /**
     * The index of the server to use from the list of available servers (0-based). Defaults to the first server.
     */
    private int serverIdx = 0;
    /**
     * Global parameter configuration for all SDK operations.
     */
    private Globals globals = new Globals();
    /**
     * Security configuration for API authentication.
     */
    private Security security = new Security();

    /**
     * Gets the base URL for the API server.
     *
     * @return the base URL for the API server
     */
    public String getServerUrl() {
        return serverUrl;
    }

    /**
     * Sets the base URL for the API server.
     *
     * @param serverUrl the base URL for the API server
     */
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    /**
     * Gets the retry configuration for API calls that fail due to transient errors.
     *
     * @return the retry configuration
     */
    public RetryConfig getRetryConfig() {
        return retryConfig;
    }

    /**
     * Sets the retry configuration for API calls that fail due to transient errors.
     *
     * @param retryConfig the retry configuration to use
     */
    public void setRetryConfig(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    /**
     * Gets the HTTP client configuration for API requests.
     *
     * @return the HTTP client configuration
     */
    public HttpClient getHttpClient() {
        return httpClient;
    }

    /**
     * Sets the HTTP client configuration for API requests.
     *
     * @param httpClient the HTTP client configuration to use
     */
    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
    /**
     * Gets the index of the server to use from the list of available servers (0-based).
     *
     * @return the server index
     */
    public int getServerIdx() {
        return serverIdx;
    }

    /**
     * Sets the index of the server to use from the list of available servers (0-based).
     *
     * @param serverIdx the server index to use
     */
    public void setServerIdx(int serverIdx) {
        this.serverIdx = serverIdx;
    }
    /**
     * Gets the global parameter configuration for all SDK operations.
     *
     * @return the global parameters configuration
     */
    public Globals getGlobals() {
        return globals;
    }

    /**
     * Sets the global parameter configuration for all SDK operations.
     *
     * @param globals the global parameters configuration to use
     */
    public void setGlobals(Globals globals) {
        this.globals = globals;
    }
    /**
     * Gets the security configuration for API authentication.
     *
     * @return the security configuration
     */
    public Security getSecurity() {
        return security;
    }

    /**
     * Sets the security configuration for API authentication.
     *
     * @param security the security configuration to use
     */
    public void setSecurity(Security security) {
        this.security = security;
    }

    /**
     * Retry configuration properties
     */
    public static class RetryConfig {
        
        /**
         * Constructor.
         */
        public RetryConfig() {
        }
        
        /**
         * The retry strategy to use for failed requests.
         */
        private io.moov.sdk.utils.RetryConfig.Strategy strategy;
        
        /**
         * Configuration for exponential backoff retry strategy. Only used when strategy is set to BACKOFF.
         */
        private Backoff backoff = new Backoff();

        /**
         * Gets the retry strategy to use for failed requests.
         *
         * @return the retry strategy
         */
        public io.moov.sdk.utils.RetryConfig.Strategy getStrategy() {
            return strategy;
        }

        /**
         * Sets the retry strategy to use for failed requests.
         *
         * @param strategy the retry strategy to use
         */
        public void setStrategy(io.moov.sdk.utils.RetryConfig.Strategy strategy) {
            this.strategy = strategy;
        }

        /**
         * Gets the backoff configuration for exponential backoff retry strategy.
         *
         * @return the backoff configuration
         */
        public Backoff getBackoff() {
            return backoff;
        }

        /**
         * Sets the backoff configuration for exponential backoff retry strategy.
         *
         * @param backoff the backoff configuration to use
         */
        public void setBackoff(Backoff backoff) {
            this.backoff = backoff;
        }

        /**
         * Backoff retry configuration matching BackoffStrategy fields
         */
        public static class Backoff {
            
            /**
             * Constructor.
             */
            public Backoff() {
            }
            
            /**
             * The initial delay before the first retry attempt. Supports duration formats like "500ms", "1s", "2m".
             */
            private Duration initialInterval = Duration.ofMillis(500);
            
            /**
             * The maximum delay between retry attempts. The backoff will not exceed this value.
             */
            private Duration maxInterval = Duration.ofSeconds(60);
            
            /**
             * The maximum total time to spend on all retry attempts. Retries will stop after this duration.
             */
            private Duration maxElapsedTime = Duration.ofHours(1);
            
            /**
             * The multiplier for exponential backoff. Each retry delay is multiplied by this factor (e.g., 1.5 means 50% increase).
             */
            private double baseFactor = 1.5;
            
            /**
             * Random jitter factor to avoid thundering herd problems. Value between 0.0 (no jitter) and 1.0 (full jitter).
             */
            private double jitterFactor = 0.5;
            
            /**
             * Whether to retry requests that fail due to connection errors (e.g., connection refused, timeout).
             */
            private boolean retryConnectError = false;
            
            /**
             * Whether to retry requests that fail due to read timeout errors (server doesn't respond within timeout).
             */
            private boolean retryReadTimeoutError = false;

            /**
             * Gets the initial delay before the first retry attempt.
             *
             * @return the initial delay duration
             */
            public Duration getInitialInterval() {
                return initialInterval;
            }

            /**
             * Sets the initial delay before the first retry attempt.
             *
             * @param initialInterval the initial delay duration
             */
            public void setInitialInterval(Duration initialInterval) {
                this.initialInterval = initialInterval;
            }

            /**
             * Gets the maximum delay between retry attempts.
             *
             * @return the maximum delay duration
             */
            public Duration getMaxInterval() {
                return maxInterval;
            }

            /**
             * Sets the maximum delay between retry attempts.
             *
             * @param maxInterval the maximum delay duration
             */
            public void setMaxInterval(Duration maxInterval) {
                this.maxInterval = maxInterval;
            }

            /**
             * Gets the maximum total time to spend on all retry attempts.
             *
             * @return the maximum elapsed time duration
             */
            public Duration getMaxElapsedTime() {
                return maxElapsedTime;
            }

            /**
             * Sets the maximum total time to spend on all retry attempts.
             *
             * @param maxElapsedTime the maximum elapsed time duration
             */
            public void setMaxElapsedTime(Duration maxElapsedTime) {
                this.maxElapsedTime = maxElapsedTime;
            }

            /**
             * Gets the multiplier for exponential backoff.
             *
             * @return the base factor for exponential backoff
             */
            public double getBaseFactor() {
                return baseFactor;
            }

            /**
             * Sets the multiplier for exponential backoff.
             *
             * @param baseFactor the base factor for exponential backoff
             */
            public void setBaseFactor(double baseFactor) {
                this.baseFactor = baseFactor;
            }

            /**
             * Gets the random jitter factor to avoid thundering herd problems.
             *
             * @return the jitter factor (0.0 to 1.0)
             */
            public double getJitterFactor() {
                return jitterFactor;
            }

            /**
             * Sets the random jitter factor to avoid thundering herd problems.
             *
             * @param jitterFactor the jitter factor (0.0 to 1.0)
             */
            public void setJitterFactor(double jitterFactor) {
                this.jitterFactor = jitterFactor;
            }

            /**
             * Gets whether to retry requests that fail due to connection errors.
             *
             * @return true if connection errors should be retried, false otherwise
             */
            public boolean isRetryConnectError() {
                return retryConnectError;
            }

            /**
             * Sets whether to retry requests that fail due to connection errors.
             *
             * @param retryConnectError true to retry connection errors, false otherwise
             */
            public void setRetryConnectError(boolean retryConnectError) {
                this.retryConnectError = retryConnectError;
            }

            /**
             * Gets whether to retry requests that fail due to read timeout errors.
             *
             * @return true if read timeout errors should be retried, false otherwise
             */
            public boolean isRetryReadTimeoutError() {
                return retryReadTimeoutError;
            }

            /**
             * Sets whether to retry requests that fail due to read timeout errors.
             *
             * @param retryReadTimeoutError true to retry read timeout errors, false otherwise
             */
            public void setRetryReadTimeoutError(boolean retryReadTimeoutError) {
                this.retryReadTimeoutError = retryReadTimeoutError;
            }
        }
    }
    
    /**
     * HTTP client configuration properties
     */
    public static class HttpClient {
        
        /**
         * Constructor.
         */
        public HttpClient() {
        }
        
        /**
         * Whether to enable debug logging for HTTP requests and responses, including JSON body content.
         */
        private boolean enableDebugLogging = false;
        
        /**
         * Collection of header names (case-insensitive) whose values will be redacted in debug logs.
         * By default, Authorization and X-API-KEY headers are redacted for security.
         */
        private Collection<String> redactedHeaders = Set.of("Authorization", "X-API-KEY");

        /**
         * Gets whether debug logging is enabled for HTTP requests and responses.
         *
         * @return true if debug logging is enabled, false otherwise
         */
        public boolean isEnableDebugLogging() {
            return enableDebugLogging;
        }

        /**
         * Sets whether to enable debug logging for HTTP requests and responses.
         *
         * @param enableDebugLogging true to enable debug logging, false otherwise
         */
        public void setEnableDebugLogging(boolean enableDebugLogging) {
            this.enableDebugLogging = enableDebugLogging;
        }
        
        /**
         * Gets the collection of header names whose values will be redacted in debug logs.
         *
         * @return the collection of header names to redact
         */
        public Collection<String> getRedactedHeaders() {
            return redactedHeaders;
        }
        
        /**
         * Sets the collection of header names whose values will be redacted in debug logs.
         *
         * @param redactedHeaders the collection of header names to redact
         */
        public void setRedactedHeaders(Collection<String> redactedHeaders) {
            this.redactedHeaders = redactedHeaders;
        }
    }

    /**
     * Global parameters configuration properties
     */
    public static class Globals {
        
        /**
         * Constructor.
         */
        public Globals() {
        }
        
        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where
         * - `YYYY` is the year
         * - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         * - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
         * - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes
         * and should be treated as a beta release.
         */
        private String xMoovVersion;

        /**
         * Gets the global x-moov-version parameter.
         *
         * @return the x-moov-version value
         */
        public String getXMoovVersion() {
            return xMoovVersion;
        }

        /**
         * Sets the global x-moov-version parameter.
         *
         * @param xMoovVersion the x-moov-version value to use
         */
        public void setXMoovVersion(String xMoovVersion) {
            this.xMoovVersion = xMoovVersion;
        }
    }

    /**
     * Security configuration properties
     */
    public static class Security {

        /**
         * Constructor.
         */
        public Security() {
        }
        /**
         * username for authentication.
         */
        private String username;
        
        /**
         * Gets the username value.
         *
         * @return the username value
         */
        public String getUsername() {
            return username;
        }

        /**
         * Sets the username value.
         *
         * @param username the username value to use
         */
        public void setUsername(String username) {
            this.username = username;
        }
        /**
         * password for authentication.
         */
        private String password;
        
        /**
         * Gets the password value.
         *
         * @return the password value
         */
        public String getPassword() {
            return password;
        }

        /**
         * Sets the password value.
         *
         * @param password the password value to use
         */
        public void setPassword(String password) {
            this.password = password;
        }
    }
}