/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import java.util.concurrent.TimeUnit;

import io.moov.sdk.utils.BackoffStrategy;
import io.moov.sdk.utils.HTTPClient;
import io.moov.sdk.utils.RetryConfig;
import io.moov.sdk.utils.SpeakeasyHTTPClient;
import java.lang.IllegalStateException;
import java.lang.String;
import java.lang.System;
import java.util.Optional;
import java.util.function.Consumer;


/**
 * Spring Boot Auto Configuration for sdk SDK
 * This configuration class automatically configures the sdk SDK
 * when Spring Boot detects it on the classpath.
 */
@AutoConfiguration
@ConditionalOnClass(Moov.class)
@EnableConfigurationProperties(SDKAutoConfigProperties.class)
public class SDKAutoConfig {

    /**
     * Constructor.
     */
    public SDKAutoConfig() {
    }

    /**
     * Creates a RetryConfig bean from properties if retry is enabled.
     * 
     * @param properties the configuration properties
     * @return A configured RetryConfig instance
     */
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix = "sdk.retry-config", name = "strategy")
    public RetryConfig retryConfig(SDKAutoConfigProperties properties) {
        SDKAutoConfigProperties.RetryConfig retryProps = properties.getRetryConfig();
        
        if (RetryConfig.Strategy.BACKOFF.equals(retryProps.getStrategy())) {
            SDKAutoConfigProperties.RetryConfig.Backoff backoff = retryProps.getBackoff();
            return RetryConfig.builder()
                .backoff(
                    BackoffStrategy.builder()
                        .initialInterval(backoff.getInitialInterval().toMillis(), TimeUnit.MILLISECONDS)
                        .maxInterval(backoff.getMaxInterval().toMillis(), TimeUnit.MILLISECONDS)
                        .maxElapsedTime(backoff.getMaxElapsedTime().toMillis(), TimeUnit.MILLISECONDS)
                        .baseFactor(backoff.getBaseFactor())
                        .jitterFactor(backoff.getJitterFactor())
                        .retryConnectError(backoff.isRetryConnectError())
                        .retryReadTimeoutError(backoff.isRetryReadTimeoutError())
                        .build()
                )
                .build();
        }
        
        // Default retry config for other strategies
        return RetryConfig.builder().build();
    }

    /**
     * Creates a {@code Consumer<String>} bean for HTTP debug logging if none exists.
     * This logger is used by the SpeakeasyHTTPClient for debug output when debug logging is enabled.
     * By default, it logs to {@code System.out}, but can be customized by providing your own {@code Consumer<String>} bean.
     *
     * @return A {@code Consumer<String>} that logs messages to {@code System.out}
     */
    @Bean
    @ConditionalOnMissingBean
    public Consumer<String> httpLogger() {
        return System.out::println;
    }

    /**
     * Creates an HTTPClient bean if none exists.
     *
     * @param properties the configuration properties
     * @param httpLogger the logger for HTTP debug output
     * @return A configured HTTPClient instance
     */
    @Bean
    @ConditionalOnMissingBean
    public HTTPClient httpClient(SDKAutoConfigProperties properties, Consumer<String> httpLogger) {
        SDKAutoConfigProperties.HttpClient httpClientProps = properties.getHttpClient();

        // Configure the static logger
        SpeakeasyHTTPClient.setLogger(httpLogger);

        if (httpClientProps != null) {
            // Configure debug logging
            SpeakeasyHTTPClient.setDebugLogging(httpClientProps.isEnableDebugLogging());

            // Configure redacted headers
            if (httpClientProps.getRedactedHeaders() != null && !httpClientProps.getRedactedHeaders().isEmpty()) {
                SpeakeasyHTTPClient.setRedactedHeaders(httpClientProps.getRedactedHeaders());
            }
        }

        return new SpeakeasyHTTPClient();
    }
    /**
     * Creates a SecuritySource bean if none exists and security properties are configured.
     *
     * @param properties the configuration properties
     * @return A configured SecuritySource instance
     */
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnPropertyPrefix(prefix = "sdk.security")
    public SecuritySource securitySource(SDKAutoConfigProperties properties) {SDKAutoConfigProperties.Security securityProps = properties.getSecurity();
        io.moov.sdk.models.components.Security.Builder securityBuilder = io.moov.sdk.models.components.Security.builder();
        boolean hasAnySecurityConfiguration = false;
        // Build username security from direct properties (primitive value)
        if (securityProps.getUsername() != null) {
            securityBuilder.username(securityProps.getUsername());
            hasAnySecurityConfiguration = true;
        }
        // Build password security from direct properties (primitive value)
        if (securityProps.getPassword() != null) {
            securityBuilder.password(securityProps.getPassword());
            hasAnySecurityConfiguration = true;
        }
        
        if (!hasAnySecurityConfiguration) {
            throw new IllegalStateException("Security configuration is present but no security options are configured. " +
                "Please configure at least one security option in your application properties.");
        }
        
        return SecuritySource.of(securityBuilder.build());
    }

    /**
     * Creates the SDKConfiguration bean as the single source of truth for all SDK configuration.
     *
     * @param properties the configuration properties
     * @param httpClient the HTTP client bean
     * @param hooks the hooks bean
     * @param securitySource the security source bean (optional)
     * @param globals the globals configuration bean
     * @param retryConfig the retry config bean (optional)
     * @return A configured SDKConfiguration instance
     */
    @Bean
    @ConditionalOnMissingBean
    public SDKConfiguration sdkConfiguration(
            SDKAutoConfigProperties properties,
            HTTPClient httpClient,
            io.moov.sdk.utils.Hooks hooks,
            SecuritySource securitySource,
            io.moov.sdk.utils.Globals globals,
            Optional<RetryConfig> retryConfig) {
        
        SDKConfiguration sdkConfiguration = new SDKConfiguration();
        
        sdkConfiguration.setClient(httpClient);
        
        sdkConfiguration.setHooks(hooks);
        sdkConfiguration.setSecuritySource(securitySource);
        
        if (properties.getServerUrl() != null) {
            sdkConfiguration.setServerUrl(properties.getServerUrl());
        }
        sdkConfiguration.setServerIdx(properties.getServerIdx());
        sdkConfiguration.setGlobals(globals);
        
        sdkConfiguration.setRetryConfig(retryConfig);
        
        return sdkConfiguration;
    }

    /**
     * Creates the main SDK bean using the configured SDKConfiguration.
     *
     * @param sdkConfiguration the configured SDKConfiguration bean
     * @return A configured Moov instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Moov moov(SDKConfiguration sdkConfiguration) {
        return new Moov(sdkConfiguration);
    }

    /**
     * Creates a Globals configuration bean if none exists, populated from properties.
     *
     * @param properties the configuration properties
     * @return A configured Globals instance
     */
    @Bean
    @ConditionalOnMissingBean
    public io.moov.sdk.utils.Globals globals(SDKAutoConfigProperties properties) {
        io.moov.sdk.utils.Globals globals = new io.moov.sdk.utils.Globals();
        
        // Populate globals from properties
        SDKAutoConfigProperties.Globals globalProps = properties.getGlobals();
        if (globalProps.getXMoovVersion() != null) {
            globals.putParam("header", "xMoovVersion", globalProps.getXMoovVersion());
        }
        
        return globals;
    }

    /**
     * Creates a Hooks configuration bean if none exists.
     *
     * @return A configured Hooks instance
     */
    @Bean
    @ConditionalOnMissingBean
    public io.moov.sdk.utils.Hooks hooks() {
        return new io.moov.sdk.utils.Hooks();
    }
    /**
     * Creates a Accounts sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Accounts instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Accounts accounts(Moov moov) {
        return moov.accounts();
    }
    /**
     * Creates a Adjustments sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Adjustments instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Adjustments adjustments(Moov moov) {
        return moov.adjustments();
    }
    /**
     * Creates a ApplePay sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured ApplePay instance
     */
    @Bean
    @ConditionalOnMissingBean
    public ApplePay applePay(Moov moov) {
        return moov.applePay();
    }
    /**
     * Creates a BankAccounts sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured BankAccounts instance
     */
    @Bean
    @ConditionalOnMissingBean
    public BankAccounts bankAccounts(Moov moov) {
        return moov.bankAccounts();
    }
    /**
     * Creates a Branding sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Branding instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Branding branding(Moov moov) {
        return moov.branding();
    }
    /**
     * Creates a Capabilities sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Capabilities instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Capabilities capabilities(Moov moov) {
        return moov.capabilities();
    }
    /**
     * Creates a Cards sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Cards instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Cards cards(Moov moov) {
        return moov.cards();
    }
    /**
     * Creates a Disputes sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Disputes instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Disputes disputes(Moov moov) {
        return moov.disputes();
    }
    /**
     * Creates a FeePlans sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured FeePlans instance
     */
    @Bean
    @ConditionalOnMissingBean
    public FeePlans feePlans(Moov moov) {
        return moov.feePlans();
    }
    /**
     * Creates a Files sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Files instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Files files(Moov moov) {
        return moov.files();
    }
    /**
     * Creates a PaymentLinks sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured PaymentLinks instance
     */
    @Bean
    @ConditionalOnMissingBean
    public PaymentLinks paymentLinks(Moov moov) {
        return moov.paymentLinks();
    }
    /**
     * Creates a PaymentMethods sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured PaymentMethods instance
     */
    @Bean
    @ConditionalOnMissingBean
    public PaymentMethods paymentMethods(Moov moov) {
        return moov.paymentMethods();
    }
    /**
     * Creates a Representatives sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Representatives instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Representatives representatives(Moov moov) {
        return moov.representatives();
    }
    /**
     * Creates a Scheduling sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Scheduling instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Scheduling scheduling(Moov moov) {
        return moov.scheduling();
    }
    /**
     * Creates a Statements sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Statements instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Statements statements(Moov moov) {
        return moov.statements();
    }
    /**
     * Creates a Sweeps sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Sweeps instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Sweeps sweeps(Moov moov) {
        return moov.sweeps();
    }
    /**
     * Creates a AccountTerminalApplications sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured AccountTerminalApplications instance
     */
    @Bean
    @ConditionalOnMissingBean
    public AccountTerminalApplications accountTerminalApplications(Moov moov) {
        return moov.accountTerminalApplications();
    }
    /**
     * Creates a Support sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Support instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Support support(Moov moov) {
        return moov.support();
    }
    /**
     * Creates a Transfers sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Transfers instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Transfers transfers(Moov moov) {
        return moov.transfers();
    }
    /**
     * Creates a Underwriting sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Underwriting instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Underwriting underwriting(Moov moov) {
        return moov.underwriting();
    }
    /**
     * Creates a Wallets sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Wallets instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Wallets wallets(Moov moov) {
        return moov.wallets();
    }
    /**
     * Creates a WalletTransactions sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured WalletTransactions instance
     */
    @Bean
    @ConditionalOnMissingBean
    public WalletTransactions walletTransactions(Moov moov) {
        return moov.walletTransactions();
    }
    /**
     * Creates a Avatars sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Avatars instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Avatars avatars(Moov moov) {
        return moov.avatars();
    }
    /**
     * Creates a EndToEndEncryption sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured EndToEndEncryption instance
     */
    @Bean
    @ConditionalOnMissingBean
    public EndToEndEncryption endToEndEncryption(Moov moov) {
        return moov.endToEndEncryption();
    }
    /**
     * Creates a EnrichedAddress sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured EnrichedAddress instance
     */
    @Bean
    @ConditionalOnMissingBean
    public EnrichedAddress enrichedAddress(Moov moov) {
        return moov.enrichedAddress();
    }
    /**
     * Creates a EnrichedProfile sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured EnrichedProfile instance
     */
    @Bean
    @ConditionalOnMissingBean
    public EnrichedProfile enrichedProfile(Moov moov) {
        return moov.enrichedProfile();
    }
    /**
     * Creates a Industries sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Industries instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Industries industries(Moov moov) {
        return moov.industries();
    }
    /**
     * Creates a Institutions sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Institutions instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Institutions institutions(Moov moov) {
        return moov.institutions();
    }
    /**
     * Creates a IssuingTransactions sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured IssuingTransactions instance
     */
    @Bean
    @ConditionalOnMissingBean
    public IssuingTransactions issuingTransactions(Moov moov) {
        return moov.issuingTransactions();
    }
    /**
     * Creates a CardIssuing sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured CardIssuing instance
     */
    @Bean
    @ConditionalOnMissingBean
    public CardIssuing cardIssuing(Moov moov) {
        return moov.cardIssuing();
    }
    /**
     * Creates a Authentication sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Authentication instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Authentication authentication(Moov moov) {
        return moov.authentication();
    }
    /**
     * Creates a Onboarding sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Onboarding instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Onboarding onboarding(Moov moov) {
        return moov.onboarding();
    }
    /**
     * Creates a Ping sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Ping instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Ping ping(Moov moov) {
        return moov.ping();
    }
    /**
     * Creates a Receipts sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured Receipts instance
     */
    @Bean
    @ConditionalOnMissingBean
    public Receipts receipts(Moov moov) {
        return moov.receipts();
    }
    /**
     * Creates a TerminalApplications sub-SDK bean if none exists.
     *
     * @param moov the main SDK instance
     * @return A configured TerminalApplications instance
     */
    @Bean
    @ConditionalOnMissingBean
    public TerminalApplications terminalApplications(Moov moov) {
        return moov.terminalApplications();
    }
}