/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal.json;

import io.hotmoka.crypto.Hex;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.hotmoka.websockets.beans.api.JsonRepresentation;
import io.mokamint.node.api.ChainInfo;
import io.mokamint.node.internal.ChainInfoImpl;

public abstract class ChainInfoJson
implements JsonRepresentation<ChainInfo> {
    private final long length;
    private final String genesisHash;
    private final String headHash;
    private final String headStateId;

    protected ChainInfoJson(ChainInfo info) {
        this.length = info.getLength();
        this.genesisHash = info.getGenesisHash().map(Hex::toHexString).orElse(null);
        this.headHash = info.getHeadHash().map(Hex::toHexString).orElse(null);
        this.headStateId = info.getHeadStateId().map(Hex::toHexString).orElse(null);
    }

    public long getLength() {
        return this.length;
    }

    public String getGenesisHash() {
        return this.genesisHash;
    }

    public String getHeadHash() {
        return this.headHash;
    }

    public String getHeadStateId() {
        return this.headStateId;
    }

    public ChainInfo unmap() throws InconsistentJsonException {
        return new ChainInfoImpl(this);
    }
}

