/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.Peer;
import io.mokamint.node.internal.json.PeerJson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class PeerImpl
extends AbstractMarshallable
implements Peer {
    private final URI uri;

    public PeerImpl(URI uri) {
        this.uri = Objects.requireNonNull(uri);
    }

    public PeerImpl(PeerJson json) throws InconsistentJsonException {
        String uri = json.getUri();
        if (uri == null) {
            throw new InconsistentJsonException("uri cannot be null");
        }
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    public PeerImpl(UnmarshallingContext context) throws IOException {
        try {
            this.uri = new URI(context.readStringUnshared());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean equals(Object other) {
        Peer peer;
        return other instanceof Peer && this.uri.equals((peer = (Peer)other).getURI());
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public void into(MarshallingContext context) throws IOException {
        context.writeStringUnshared(this.uri.toString());
    }

    public int compareTo(Peer other) {
        return this.uri.compareTo(other.getURI());
    }

    public String toString() {
        String uri = this.uri.toString();
        return uri.length() > 100 ? uri.substring(0, 100) + "..." : uri;
    }
}

